#include <stdio.h>
#include <stdlib.h> // exit()
#include <objbase.h>

static void A2U(const char* In, wchar_t* Out)    {
    int Len = (int)strlen(In)+1;
    MultiByteToWideChar(CP_ACP, 0, In, Len, Out, Len*2);
    }
static void U2A(wchar_t* In, char* Out)    {
    int Len = lstrlenW(In)+1;
    WideCharToMultiByte(CP_ACP, 0, In, Len, Out, Len, 0, 0);
    }

void    DumpStream(IStream* File, int Indent=0) {
    ULONG           BytesRead;
    unsigned char   Buffer[8];
    int             Offset = 0;

    while(File->Read(Buffer, 8, &BytesRead) == S_OK
        && BytesRead > 0)   {
        printf("%*s0x%04X ", Indent, "", Offset);
        for(int i=0; i < BytesRead; ++i)
            printf("%02X ", (unsigned int)(Buffer[i]));
        printf("\n");
        Offset  += 16;
        }
    }

void    DumpStorage(IStorage* Dir, int Indent=0)  {
    HRESULT         Code;
    IEnumSTATSTG*   Enum;
    STATSTG         Info;
    IStream*        Stream;
    
    Dir->EnumElements(0, 0, 0, &Enum);
    while(Enum->Next(1, &Info, 0) == S_OK)
        {
        // convert, print out info about this file or dir
        char    Name[256];
        U2A(Info.pwcsName, Name);
        printf("%*s/%s\n", Indent, "", Name);
        
        // if it's a storage, then open it and recurse
        if(Info.type == STGTY_STORAGE)
            {
            IStorage*   SubDir;

            HRESULT Code = Dir->OpenStorage(Info.pwcsName, 0,
                STGM_READ|STGM_SHARE_EXCLUSIVE,
                0, 0, &SubDir);
            if(Code != S_OK)
                {
                fprintf(stderr, "Could not open storage "
                    "'%s'\n", Name);
                exit(EXIT_FAILURE);
                }
            else
                {
                DumpStorage(SubDir, Indent+4);
                SubDir->Release();
                }
            }
        // if it's a file, open and dump it
        else if(Info.type == STGTY_STREAM)
            {
            IStream*    File;
            
            HRESULT Code = Dir->OpenStream(Info.pwcsName, 0,
                STGM_READ|STGM_SHARE_EXCLUSIVE,
                0, &File);
            if(Code != S_OK)
                {
                fprintf(stderr, "Could not open stream "
                    "'%s'\n", Name);
                exit(EXIT_FAILURE);
                }
            else
                {
                DumpStream(File, Indent+4);
                File->Release();
                }
            }
        CoTaskMemFree(Info.pwcsName);
        }
    Enum->Release();
    }


void Usage(void)    {
    fprintf(stderr, "Usage: comdump <filename>\n");
    exit(EXIT_FAILURE);
    }

void main(int argc, char** argv)    {
    if(argc != 2)
        Usage();
    wchar_t     wPath[256];
    IStorage*   Root;
    HRESULT     Result;

    A2U(argv[1], wPath);
    Result = StgOpenStorage(wPath, 0, STGM_READ
        |STGM_SHARE_EXCLUSIVE, 0, 0, &Root);
    if(Result != S_OK)
        fprintf(stderr, "Could not open '%s' (error code %d)",
            argv[1], Result);
    else
        {
        printf("Dump of compound file '%s'\n", argv[1]);
        DumpStorage(Root);
        Root->Release();
        }
    exit(EXIT_SUCCESS);
    }

