/* Windows Task Monitor, Written by Al Lehman       */
/* use -DSTRICT when compiling any W/DDJ code!      */
#include <windows.h>
#include <string.h>
#include "taskmon.h"

#ifdef __WATCOMC__
    #pragma off (unreferenced);
#endif

BOOL FAR PASCAL _export DlgProc(HWND hDlg, UINT message,
        UINT wParam, LONG lParam);
BOOL LoadTaskList(HWND hDlg);

/* undoc functions - TASKMAN uses them, so we will too. */
void (FAR PASCAL *TileChildWindows)(HWND , WORD);
void (FAR PASCAL *CascadeChildWindows)(HWND , WORD);
void (FAR PASCAL *SwitchToThisWindow)(HWND, BOOL);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine, int nCmdShow) {
    HINSTANCE User;
/* Must be 3.1 or higher version of undocumented functions. */
    if(HIBYTE(LOWORD(GetVersion())) < 0x0a)
        return TRUE;     
    if(hPrevInstance)
        {
        BringWindowToTop(FindWindow(NULL, (LPSTR)"TASK MONITOR"));   
        return FALSE;
        }
    User = LoadLibrary("user.exe");
#define LOAD(x) *(FARPROC*)&x=GetProcAddress(User, #x)
    LOAD(TileChildWindows);
    LOAD(CascadeChildWindows);
    LOAD(SwitchToThisWindow);
    DialogBox(hInstance, "TASKLISTDLG", HWND_DESKTOP, DlgProc);
    FreeLibrary(User);
    return FALSE;
   }

#define SENDLBX(M,W,L) SendDlgItemMessage(hDlg, \
    IDC_LISTBOX, M, W, L)
#define CURLBX()    ((short)SENDLBX(LB_GETCURSEL,0,0))
#define MSG(s) MessageBox(hDlg,s,"Sorry",MB_ICONSTOP | MB_OK)
#define TOPWND() GetDesktopWindow()

HWND  TaskWindow(HWND hDlg) {
    short nIndex = (short)CURLBX();
    return  (HWND)SENDLBX(LB_GETITEMDATA, nIndex, 0L);
    }

BOOL DlgCommand(HWND hDlg, WPARAM wParam, LPARAM lParam) {
    HWND    wnd;
    switch(wParam)
    {
    case IDC_ENDTASK:
        wnd     = TaskWindow(hDlg);
        if(IsWindow(wnd))
            SendMessage(wnd, WM_CLOSE, 0, 0L);
        else
            MSG("Bad window handle, won't close it.");
        if(!IsWindow(wnd))
            {
            short nIndex = CURLBX();
            /*window no longer exists/remove from list.*/
            SENDLBX(LB_DELETESTRING, nIndex, 0L);
            /*Reposition listbox highlighted selection*/
            SENDLBX(LB_SETCURSEL, nIndex?nIndex-1:0, 0L);
            }
        return TRUE;
    case IDC_LISTBOX:
        if(HIWORD(lParam) != LBN_DBLCLK)
            return FALSE;
        /* Else fall through... */
    case IDC_SWITCHTO:
        if((wnd=TaskWindow(hDlg)) == 0)
            {
            MSG("Bad window handle, won't switch");
            return TRUE;
            }
/* Use undocumented SwitchToThisWindow() to switch focus to
 * the selected window (TASKMAN uses it, too) then exit. */
        SwitchToThisWindow(wnd, TRUE);
        EndDialog(hDlg, 0);
        return TRUE;
    case IDC_CASCADE:
        ShowWindow(hDlg, SW_HIDE);
        if(GetKeyState(VK_SHIFT) < 0)
            CascadeChildWindows(TOPWND(),MDITILE_HORIZONTAL);
        else
            CascadeChildWindows(TOPWND(),MDITILE_VERTICAL);
        ShowWindow(hDlg, SW_SHOW);
        return TRUE;
    case IDC_TILE:
        ShowWindow(hDlg, SW_HIDE);
        if(GetKeyState(VK_SHIFT) < 0)
            TileChildWindows(TOPWND(), MDITILE_HORIZONTAL);
        else
            TileChildWindows(TOPWND(), MDITILE_VERTICAL);
        ShowWindow(hDlg, SW_SHOW);
        return TRUE;
    case IDC_ARRANGEICONS:
        ArrangeIconicWindows(TOPWND());
        return TRUE;
/* ESC key will result in EndDialog() */
    default:
    case IDC_CANCEL:
        EndDialog(hDlg, 0);
        return TRUE;
    }
}


BOOL CALLBACK _export DlgProc(HWND hDlg, UINT message,
            WPARAM wParam, LPARAM lParam) {
    HMENU hmenu;
    switch(message)
    {
    case WM_INITDIALOG: /* Give the people a choice! */
        hmenu = GetSystemMenu(hDlg, FALSE);
        AppendMenu(hmenu, MF_SEPARATOR, 0, (LPSTR) NULL);
        AppendMenu(hmenu, MF_STRING, IDM_EXECTASKMAN,
            "Execute &TASKMAN.EXE");
        return TRUE;
    case WM_CLOSE:
        EndDialog(hDlg, 0);
        return TRUE;
    case WM_ACTIVATE:   /* load the listbox */
    /* If wParam is either WA_ACTIVE or WA_CLICKACTIVE focus
       is switched to us, so update the task list.        */
        if(wParam != WA_INACTIVE)
            LoadTaskList(hDlg);
        return TRUE;
   case WM_SYSCOMMAND:
        if(wParam != IDM_EXECTASKMAN)
            return FALSE;
    /* EndDialog() first to not show in TASKMAN's list. */
         EndDialog(hDlg, 0);
         WinExec((LPSTR)"TASKMAN.EXE", SW_SHOWNORMAL);
         return TRUE;
   case WM_COMMAND:
        return DlgCommand(hDlg, wParam, lParam);
    }
    return FALSE;
}


BOOL LoadTaskList(HWND hDlg) {
    HWND hwnd;
    char szBuf[200];

    SENDLBX(LB_RESETCONTENT, 0, 0); /* clear listbox */

/* Make a list of top level windows. */
    hwnd = GetWindow(GetTopWindow(TOPWND()),
        GW_HWNDFIRST);
    for(; hwnd; hwnd=GetWindow(hwnd, GW_HWNDNEXT))
        if(hwnd != hDlg)
            {
            GetWindowText(hwnd, szBuf, sizeof(szBuf));
            if(strlen(szBuf))
/* If the window is not our own and it has a title,
  save its handle as HIWORD of the DWORD associtated
  with its listbox item.                            */
                SENDLBX(LB_SETITEMDATA,(WPARAM)SENDLBX(
                    LB_ADDSTRING, 0, (LPARAM)szBuf),
                    (LPARAM)(void FAR *)hwnd);
            }

/* Set the focus to the first item in the listbox. */
    SENDLBX(LB_SETCURSEL, 0, 0L);
    return TRUE;
}
