   title vw32demo
   page ,132

.386p

.xlist
   include vmm.inc
   include vwin32.inc
   include debug.inc
   include vw32svc.inc
   include winerror.inc
; winerror.inc sets this to none, this conflicts with /Cx
option casemap:notpublic    
.list

W32STRUC     struc
 W32T_SERVICE  dd ?  ; service #
 W32T_HANDLER  dd ?  ; pointer to the previous handler address
 W32T_HITCNT   dd ?  ; number of times this service got hit
W32STRUC     ends

W32_THUNK    struc
 W32T_Call   db 0E8h ;opcode for 'call imm'
 W32T_Target dd 0    ;call target
 W32T_Data   db (type W32STRUC) dup (?)
W32_THUNK    ends

VxD_DATA_SEG
HLIST dd 0       ; main linked list handle
vwin32_int21h_handler   dd  0 ; original 002A0010h handler

VW32Demo_Major  equ 1
VW32Demo_Minor  equ 0

; Win32 DeviceIOControl dispatch table
align 4
ioctldisp   label   dword
   dd  offset32 ioctl_openclose
   dd  offset32 ioctl_openclose
   dd  offset32 ioctl_HitCount
   dd  offset32 ioctl_RmDir
ioctlcnt equ ($-ioctldisp)/4
; Win32 service table
Create_Win32_Services=1
Begin_Win32_Services VW32DEMO
Local_Win32_Service VW32DEMO, VW32Demo_GetObfuscator, 1
End_Win32_Services VW32DEMO
VxD_DATA_ENDS

Declare_Virtual_Device VW32DEMO, \
                       VW32Demo_Major, \
                       VW32Demo_Minor, \
                       VW32Demo_Control

VxD_LOCKED_CODE_SEG

VW32Demo_Control proc
Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, VW32Demo_DynamicInit
Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, VW32Demo_DynamicExit
Control_Dispatch W32_DEVICEIOCONTROL, VW32Demo_W32dioc
   clc
   ret
VW32Demo_Control endp

VW32Demo_DynamicInit proc
   ; main linked list
   mov     eax, LF_Alloc_Error + LF_Async + LF_Use_Heap
   mov     ecx, type W32_THUNK
   VMMCall List_Create
   .IF CARRY?
      Trace_Out 'VW32Demo: Unable to create main linked list'
   .ELSE
      mov     [HLIST], esi

      ; hook all Win32 services that exist at the moment
      cCall   _Enumerate_Win32_Services,\
                         <<offset32 HookWin32Services>>

      ; register our own Win32 service table
      VMMCall _Register_Win32_Services,<<offset32 VW32Demo_DDB>,\
                            <offset32 VW32Demo_Win32_Services>>
      clc
   .ENDIF  
   ret
VW32Demo_DynamicInit endp

VW32Demo_DynamicExit proc
   ; 'unregister' our Win32 services
   VMMCall _Register_Win32_Services,<<offset32 VW32Demo_DDB>,0>
    
   ; unhook all win32 services
   mov     esi, [HLIST]
   VMMCall List_Get_First
   .WHILE !ZERO?
      push    eax
      cCall   _Unhook_Win32_Service,\
                <[eax].W32T_Data.W32T_SERVICE,eax>
      pop     eax
      VMMCall List_Get_Next
   .ENDW
    
   VMMCall List_Destroy
   clc
   ret
VW32Demo_DynamicExit      endp

VW32Demo_W32dioc proc uses esi edi ebx ebp
   ; get ioctl index
   ; increment it for CLOSEHANDLE to start the table
   mov   eax, [esi].dwIoControlCode
   inc   eax
   .IF eax >= ioctlcnt
      ; not supported service number
      mov   eax, ERROR_NOT_SUPPORTED
      stc
   .ELSE
      ; call through the ioctl branch table    
      mov     edi, [esi].lpvInBuffer
      call    ioctldisp[eax*4]

      xor   eax, eax
      clc
   .ENDIF
   ret
VW32Demo_W32dioc  endp

; deviceIOcontrol services
ioctl_openclose proc
   ret
ioctl_openclose endp

ioctl_HitCount proc
   mov     esi, [HLIST]
   .IF [edi]
      mov     eax, [edi]
      VMMCall List_Get_Next
   .ELSE
      VMMCall List_Get_First  
   .ENDIF
   .IF !ZERO?
      mov     [edi], eax
      push    [eax].W32T_Data.W32T_SERVICE
      pop     [edi+4]
      push    [eax].W32T_Data.W32T_HITCNT
      pop     [edi+8]
   .ELSE
      mov     dword ptr [edi], 0
   .ENDIF
   ret
ioctl_HitCount endp

; hook VWIN32 Int21 service with the handler that
; simulates 'Unable to remove directory' function
ioctl_RmDir proc
   .IF ![vwin32_int21h_handler]
      cCall   _Hook_Win32_Service,<002A0010h,\
                       <offset32 VW32Demo_Int21hHandler>>
      mov     [vwin32_int21h_handler], eax ; save original handler
   .ELSE
      cCall   _Unhook_Win32_Service,<002A0010h,\
                       <offset32 VW32Demo_Int21hHandler>>
      mov     [vwin32_int21h_handler], 0
   .ENDIF
   ret
ioctl_RmDir endp

; Enumerate_Win32_Services enumeration procedure
HookWin32Services proc C,win32svc:dword
   mov     esi, [HLIST]
   ; service stub
   VMMCall List_Allocate
   .IF !CARRY?
      mov     edx, offset32 GenericWin32Servicehandler
      mov     [eax].W32T_Call, 0e8h       ; opcode for call
      sub     edx,eax
      sub     edx,5                       ; immediate
      mov     [eax].W32T_Target, edx
      mov     edx, eax        
        
      ; store win32 service number
      push    win32svc
      pop     [edx].W32T_Data.W32T_SERVICE

      ; hook win32 service
      cCall   _Hook_Win32_Service,<win32svc,edx>

      ; store previous handler
      mov     [edx].W32T_Data.W32T_HANDLER, eax

      ; initialize hit count
      mov     [edx].W32T_Data.W32T_HITCNT, 0

      mov     eax, edx
      VMMCall List_Attach_Tail
   .ENDIF

   ; make _Enumerate_Win32_Services to continue for all services
   xor     eax, eax
   ret
HookWin32Services endp

GenericWin32Servicehandler proc
   pop     edx             ; points to W32 structure
   inc     [edx].W32T_HITCNT
   ; just jump to the next handler down the chain
   mov     edx, [edx].W32T_HANDLER
   jmp     [edx]
GenericWin32Servicehandler endp

VW32Demo_Int21hHandler proc stdcall,pcrs:dword,
                                    hvm:dword,
                                    int21func:dword,
                                    int21ECX:dword
   ; monitor RmDir subfunction (713Ah)
   .IF (int21func == 0713Ah)
      ; emulate 'unable to remove directory'
      ; by returning Carry set to the Win32 client
      mov     edx, pcrs
      or      [edx].Client_EFlags, CF_Mask
   .ELSE
      ; pass through all the other Int 21 requests
      leave
      mov     edx, [vwin32_int21h_handler]
      jmp     [edx]
   .ENDIF
    
   ret
VW32Demo_Int21hHandler endp

; Win32 service handler
VW32Demo_GetObfuscator proc stdcall,pcrs:dword,
                                    hvm:dword,
                                    r3pid:dword
   VxDCall VWIN32_GetCurrentProcessHandle
   ; get the value of the obfuscator
   xor     eax, r3pid
   ; return obfuscator to the Ring3 caller
   xchg    eax, pcrs
   push    pcrs
   pop     [eax].Client_EAX
    
   ret
VW32Demo_GetObfuscator endp

VxD_LOCKED_CODE_ENDS
   end
