// DialCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "CustCtrl.h"
#include "DialCtrl.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialControl

CDialControl::CDialControl()
{
	m_nMin = 0;
	m_nMax = 20;
	m_nValue = 0;
	m_nRate = 1;
	m_bDragging = FALSE;
}

CDialControl::~CDialControl()
{
}


BEGIN_MESSAGE_MAP(CDialControl, CWnd)
	//{{AFX_MSG_MAP(CDialControl)
	ON_WM_PAINT()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	ON_WM_LBUTTONDOWN()
	ON_WM_KEYDOWN()
	ON_WM_GETDLGCODE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDialControl message handlers

void CDialControl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect;
	GetClientRect(&rect);
	int nDialRadius = min(rect.Width(), rect.Height()) / 2 - 12;
	CPoint ptCenter = rect.CenterPoint();
	CRect rectCircle(ptCenter.x - nDialRadius, ptCenter.y - nDialRadius,
					 ptCenter.x + nDialRadius, ptCenter.y + nDialRadius);

	CDC dcMem, dcTemp;
	dcTemp.CreateCompatibleDC(&dc);	// temp dc for rendering
	CBitmap bitmap, *pTempOld;
	bitmap.CreateCompatibleBitmap(&dc, rect.Width(), rect.Height());
	pTempOld = dcTemp.SelectObject(&bitmap);

	// now do rendering
	CBrush brush(GetSysColor(COLOR_BTNFACE));
	CBrush *pOldBrush;
	CPen *pOldPen;
	CPen penThickBlack(PS_SOLID, 2, RGB(0, 0, 0));
	CPen penThickGray(PS_SOLID, 2, RGB(128, 128, 128));
	CPen penGray(PS_SOLID, 1, RGB(128, 128, 128));
	CPen penBlack(PS_SOLID, 1, RGB(0, 0, 0));

	dcTemp.FillRect(&rect, &brush);

	pOldBrush = dcTemp.SelectObject(&brush);
	if(IsWindowEnabled())
	{
		pOldPen = dcTemp.SelectObject(&penThickBlack);
	}
	else
	{
		pOldPen = dcTemp.SelectObject(&penThickGray);
	}
	dcTemp.Ellipse(&rectCircle);
	
	if(IsWindowEnabled())
	{
		dcTemp.SelectObject(&penBlack);
	}
	else
	{
		dcTemp.SelectObject(&penGray);
	}

	// draw min and max lines
	CPoint point1, point2;

	GetLinePoints(nDialRadius + 12, 0, point1, point2);
	dcTemp.MoveTo(ptCenter + point1);
	dcTemp.LineTo(ptCenter + point2);

	GetLinePoints(nDialRadius + 12, 100, point1, point2);
	dcTemp.MoveTo(ptCenter + point1);
	dcTemp.LineTo(ptCenter + point2);

	// now draw value line
	int nPercent = (m_nValue - m_nMin) * 100 / (m_nMax - m_nMin);
	GetLinePoints(nDialRadius, nPercent, point1, point2);
	dcTemp.MoveTo(ptCenter + point1);
	dcTemp.LineTo(ptCenter + point2);

	dcTemp.SelectObject(pOldPen);
	dcTemp.SelectObject(pOldBrush);
	
	if(GetFocus() == this)
		dcTemp.DrawFocusRect(&rect);

	// now back to the real dc
	dc.BitBlt(0, 0, rect.Width(), rect.Height(), &dcTemp, 0, 0, SRCCOPY);
	dcTemp.SelectObject(pTempOld);
}

void CDialControl::OnSetFocus(CWnd* pOldWnd) 
{
	CWnd::OnSetFocus(pOldWnd);
	
	Invalidate();
	
}

void CDialControl::OnKillFocus(CWnd* pNewWnd) 
{
	CWnd::OnKillFocus(pNewWnd);
	
	Invalidate();
	
}

void CDialControl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	SetFocus();

	m_bDragging = TRUE;
	SetCapture();
	CalculateValFromPoint(point);	
	CWnd::OnLButtonDown(nFlags, point);
}

void CDialControl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar == VK_DOWN)
	{
		int nNewVal = max(m_nMin, m_nValue - m_nRate * (int)nRepCnt);
		if(nNewVal != m_nValue)
		{
			m_nValue = nNewVal;
			Invalidate();
			
			WPARAM wToSend = MAKELONG(GetDlgCtrlID(), DN_DOWN);
			LPARAM lToSend = (LPARAM)GetSafeHwnd();

			GetParent()->SendMessage(WM_COMMAND, wToSend, lToSend);
		}
		return;
	}
	if(nChar == VK_UP)
	{
		int nNewVal = min(m_nMax, m_nValue + m_nRate * (int)nRepCnt);
		if(nNewVal != m_nValue)
		{
			m_nValue = nNewVal;
			Invalidate();
			WPARAM wToSend = MAKELONG(GetDlgCtrlID(), DN_UP);
			LPARAM lToSend = (LPARAM)GetSafeHwnd();

			GetParent()->SendMessage(WM_COMMAND, wToSend, lToSend);
		}
		return;
	}
	
	CWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CDialControl::GetLinePoints(int nLength, int nPercent, CPoint &point1, CPoint &point2)
{
	double pi = 3.1415926535;
	double dStartRads = 1.25 * pi;
	double dOffsetRads = 1.5 * pi * (double)(nPercent)/100.0;
	double radians = dStartRads - dOffsetRads;
	point1.x = (int)(cos(radians) * (nLength - 2));
	point1.y = -(int)(sin(radians) * (nLength - 2));
	point2.x = (int)(cos(radians) * (nLength - 10));
	point2.y = -(int)(sin(radians) * (nLength - 10));
}

UINT CDialControl::OnGetDlgCode() 
{
	return CWnd::OnGetDlgCode() | DLGC_WANTARROWS;
}

void CDialControl::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(m_bDragging)
		CalculateValFromPoint(point);
	CWnd::OnMouseMove(nFlags, point);
}

void CDialControl::CalculateValFromPoint(CPoint point)
{
	CRect rect;
	GetClientRect(&rect);
	CPoint pointCenter = rect.CenterPoint();
	CPoint pointDiff = pointCenter - point;
	double pi = 3.1415926535;
	double dCos = (double)pointDiff.x / sqrt((double)(pointDiff.x * pointDiff.x + pointDiff.y * pointDiff.y));
	double dRads = acos(dCos);
	if(pointDiff.y <= 0)
		dRads += pi;

	double dOffsetRads = 1.25 * pi - dRads;
	if(dOffsetRads < 0)
		dOffsetRads += 2 * pi;
	
	if(dOffsetRads > 1.5 * pi && dOffsetRads < 1.75 * pi)
		dOffsetRads = 1.5 * pi;
	if(dOffsetRads > 1.75 * pi)
		dOffsetRads = 0;
	double dPercent = dOffsetRads / (1.5 * pi);
	if(pointDiff.y > 0)
		dPercent = 1.0 - dPercent;

	int nNewVal = m_nMin + (int)(dPercent * (m_nMax - m_nMin)); 
	if(nNewVal != m_nValue)
	{
		m_nValue = nNewVal;
		Invalidate();
		WPARAM wToSend = MAKELONG(GetDlgCtrlID(), DN_CLICK);
		LPARAM lToSend = (LPARAM)GetSafeHwnd();

		GetParent()->SendMessage(WM_COMMAND, wToSend, lToSend);
	}
}

void CDialControl::OnLButtonUp(UINT nFlags, CPoint point) 
{
	m_bDragging = FALSE;
	ReleaseCapture();	
	CWnd::OnLButtonUp(nFlags, point);
}
