// ClockCtl.cpp : implementation file
//

#include "stdafx.h"
#include "CustCtrl.h"
#include "ClockCtl.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClockControl

CClockControl::CClockControl()
{
	m_nMinutes = 0;
	m_nHours = 0;
	m_nSeconds = 0;
}

CClockControl::~CClockControl()
{
}


BEGIN_MESSAGE_MAP(CClockControl, CWnd)
	//{{AFX_MSG_MAP(CClockControl)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CClockControl message handlers

void CClockControl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect;
	GetClientRect(&rect);
	CPoint ptCenter = rect.CenterPoint();

	CDC dcMem, dcTemp;
	dcTemp.CreateCompatibleDC(&dc);	// temp dc for rendering
	CBitmap bitmap, *pTempOld;
	bitmap.CreateCompatibleBitmap(&dc, rect.Width(), rect.Height());
	pTempOld = dcTemp.SelectObject(&bitmap);
	// now do rendering
	CBrush brush(GetSysColor(COLOR_BTNFACE));
	CPen *pOldPen, penRed(PS_SOLID, 1, RGB(255, 0, 0));
	CPen penThick(PS_SOLID, 2, RGB(0, 0, 0));
	dcTemp.FillRect(&rect, &brush);

	int nMaxLength = min(rect.Width(), rect.Height()) / 2 - 5;
	CPoint pt;
	pt = GetHandPos(nMaxLength * 5 / 10, m_nHours * 30 + m_nMinutes / 2);
	pOldPen = dcTemp.SelectObject(&penThick);
	dcTemp.MoveTo(ptCenter);
	dcTemp.LineTo(ptCenter + pt);

	pt = GetHandPos(nMaxLength * 8 / 10, m_nMinutes * 6);
	dcTemp.MoveTo(ptCenter);
	dcTemp.LineTo(ptCenter + pt); 

	pt = GetHandPos(nMaxLength * 8 / 10 + 5, m_nSeconds * 6);
	dcTemp.SelectObject(&penRed);
	dcTemp.MoveTo(ptCenter);
	dcTemp.LineTo(ptCenter + pt);
	dcTemp.SelectObject(pOldPen);

	// now back to the real dc
	dc.BitBlt(0, 0, rect.Width(), rect.Height(), &dcTemp, 0, 0, SRCCOPY);
	dcTemp.SelectObject(pTempOld);
}

CPoint CClockControl::GetHandPos(int nLen, int nDegrees)
{
	double pi = 3.1415926535;
	double radians = (2 * pi * (double)(360 - nDegrees + 90) / 360.0);
	int x = (int)(cos(radians) * nLen);
	int y = -(int)(sin(radians) * nLen);

	return CPoint(x, y);
}

void CClockControl::SetToCurrentTime()
{
	CTime timeNow = CTime::GetCurrentTime();

	m_nHours = (short)(timeNow.GetHour() % 12);
	m_nMinutes = (short)timeNow.GetMinute();
	m_nSeconds = (short)timeNow.GetSecond();
}
