// wdjsrvc.c

#include <windows.h>
#include <stdio.h>
#include "wdjsrvc.h"

// private prototypes
BOOL NotifySCM(DWORD, DWORD, DWORD);
VOID ServiceMain(DWORD, LPTSTR *);
VOID ServiceHandler(DWORD);
DWORD ServiceInit(LPDWORD);
LRESULT CALLBACK ServiceDlgProc(HWND, UINT, WPARAM, LPARAM);

HANDLE  hDoneEvent = NULL, hThread = NULL;
DWORD   dwCurrentState;
SERVICE_STATUS_HANDLE  hService;

//--------------------------------------------------------------
void main(void)
{
   SERVICE_TABLE_ENTRY ServiceTable[] = {
      {GENSRV_ServiceName, (LPSERVICE_MAIN_FUNCTION)ServiceMain},
      {NULL, NULL}
   };

   // connect to  the service control manager
   StartServiceCtrlDispatcher(ServiceTable);
}

//--------------------------------------------------------------
VOID ServiceMain(DWORD dwArgc, LPTSTR *lpszArgv)
{
   DWORD   ThreadId;

   if (!(hService = RegisterServiceCtrlHandler(
         GENSRV_ServiceName,
         (LPHANDLER_FUNCTION)ServiceHandler)))
      return;

   NotifySCM(SERVICE_START_PENDING, 0, 1);

   CreateThread(0, 0, (LPTHREAD_START_ROUTINE)ServiceInit,
         NULL, 0, &ThreadId);

   NotifySCM(SERVICE_START_PENDING, 0, 2);

   if (!(hDoneEvent = CreateEvent(NULL, FALSE, FALSE, NULL)))
      return;

   NotifySCM(SERVICE_START_PENDING, 0, 3);

   if (!(hThread = CreateThread(0, 0,
         (LPTHREAD_START_ROUTINE)MainServiceThread, 0, 0,
         &ThreadId))) {
      CloseHandle(hDoneEvent);
      return;
   }

   NotifySCM(SERVICE_RUNNING, 0, 0);

   WaitForSingleObject(hDoneEvent, INFINITE);

   CloseHandle(hThread);
   CloseHandle(hDoneEvent);
   return;
}

//--------------------------------------------------------------
VOID ServiceHandler(DWORD fdwControl)
{
   switch(fdwControl) {
      case SERVICE_CONTROL_STOP:
         NotifySCM(SERVICE_STOP_PENDING, 0, 1);
         SetEvent(hDoneEvent);
         NotifySCM(SERVICE_STOPPED, 0, 0);
         break;

       case SERVICE_CONTROL_PAUSE:
         NotifySCM(SERVICE_PAUSE_PENDING, 0, 1);
         SuspendThread(hThread);
         NotifySCM(SERVICE_PAUSED, 0, 0);
         break;

      case SERVICE_CONTROL_CONTINUE:
         NotifySCM(SERVICE_CONTINUE_PENDING, 0, 1);
         ResumeThread(hThread);
         NotifySCM(SERVICE_RUNNING, 0, 0);
         break;

      case SERVICE_CONTROL_INTERROGATE:
         NotifySCM(dwCurrentState, 0, 0);
         break;

      case SERVICE_CONTROL_SHUTDOWN:
         break;
   }
}

//--------------------------------------------------------------
BOOL NotifySCM(DWORD dwState, DWORD dwWin32ExitCode,
      DWORD dwProgress)
{
   SERVICE_STATUS ServiceStatus;

   ServiceStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
   ServiceStatus.dwCurrentState = dwCurrentState = dwState;
   ServiceStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP |
      SERVICE_ACCEPT_PAUSE_CONTINUE | SERVICE_ACCEPT_SHUTDOWN;
   ServiceStatus.dwWin32ExitCode = dwWin32ExitCode;
   ServiceStatus.dwServiceSpecificExitCode = 0;
   ServiceStatus.dwCheckPoint = dwProgress;
   ServiceStatus.dwWaitHint = 5000;

   return SetServiceStatus(hService, &ServiceStatus);
}

//---------------------------------------------------------
DWORD ServiceInit(LPDWORD ThreadParam)
{
   OSVERSIONINFO OsVersionInfo;

   OsVersionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
   GetVersionEx(&OsVersionInfo);

   if (OsVersionInfo.dwMajorVersion >= 4) {
      TCHAR szMsg[MAX_PATH];
      wsprintf(szMsg, TEXT("Using %08x"), MB_SERVICE_NOTIFICATION);

      MessageBox(NULL, szMsg, TEXT("WDJSrvc"),
         MB_SERVICE_NOTIFICATION | MB_OK);
   } else {
      MessageBox(NULL, TEXT("Using 0x00040000"),
         TEXT("WDJSrvc"), 0x00040000 | MB_OK);
   }

   return TRUE;
}

//---------------------------------------------------------
DWORD MainServiceThread(LPDWORD ThreadParam)
{
   DialogBox(GetModuleHandle(NULL),
      MAKEINTRESOURCE(SERVICE_DIALOG), NULL, ServiceDlgProc);

   while (TRUE) {
      Sleep(10000);
      MessageBeep(0);
   }
   return TRUE;
}

//---------------------------------------------------------
LRESULT CALLBACK ServiceDlgProc(HWND hDlg, UINT msg,
   WPARAM wParam, LPARAM lParam)
{
   switch (msg) {
      case WM_COMMAND:
         switch(LOWORD(wParam)) {
             case IDOK:
               EndDialog(hDlg, TRUE);
               return TRUE;
      }
      break;
   }
   return FALSE;
}


