// test.c - test out bugs and bug fixes for listview control

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>

#define MAIN_DLG   "MAINDIALOG"
HINSTANCE CurrentInstance;

#define MASK LVCF_FMT|LVCF_SUBITEM|LVCF_TEXT|LVCF_WIDTH

LV_COLUMN   Columns[] = 
    {
    { MASK, LVCFMT_LEFT, 125, "Task",     4, 0 },
    { MASK, LVCFMT_LEFT, 100, "Urgency",  7, 0 },
    { MASK, LVCFMT_LEFT,  99, "Priority", 8, 0 },
    };
#define NCOLUMNS    (sizeof(Columns)/sizeof(LV_COLUMN))
void    InitView(HWND ListView)
    {
    char Data[] = "abcdefghijklm";
    int i;
    for(i=0; i < NCOLUMNS; ++i)
        ListView_InsertColumn(ListView, i, &Columns[i]);
    for(i = 0; i < 4; ++i)
        {
        LV_ITEM Info;
        memset(&Info, 0, sizeof(Info));
        Info.mask   = LVIF_TEXT | LVIF_PARAM;
        Info.pszText= Data +i;
        Info.lParam = i;
        ListView_InsertItem(ListView, &Info);
        }
    }


#ifdef __BORLANDC__
    #pragma argsused
#endif
static BOOL MainDialogCommand(HWND Dialog, int ControlId,
                              HWND Control, UINT Notify)
    {
    if((ControlId == IDOK || ControlId == IDCANCEL)
        && Notify == BN_CLICKED)
        {
        EndDialog(Dialog, ControlId);
        return TRUE;
        }
    return FALSE;
    }

static WNDPROC  OldProc;

int CALLBACK SortFunc(LPARAM lParam1, LPARAM lParam2, 
    LPARAM lParamSort)
    {
    return lParam2 < lParam2 ? -1 : 1;
    }


#define YELLOW  RGB(255,255,0)
BOOL CALLBACK MainDialog(HWND Dialog, UINT Message,
                         WPARAM wParam, LPARAM lParam)
    {
    HWND    ListView = GetDlgItem(Dialog, 104);
    switch(Message)
        {
        case    WM_INITDIALOG   :
            {
            char Buffer[16];
            RECT Foo;
            InitView(ListView);
            ListView_SetBkColor(ListView, YELLOW);
            ListView_SetTextBkColor(ListView, YELLOW);
            int Width;
            LV_COLUMN   Col;
            memset(&Col, 0, sizeof(Col));
#define BOGUS 99
            Col.mask    = LVCF_WIDTH;
            if(ListView_GetColumn(ListView, BOGUS, &Col))
                SetDlgItemInt(Dialog, 102, Col.cx, TRUE);
            else
                SetDlgItemText(Dialog, 102, "ok!");
            Width = ListView_GetColumnWidth(ListView, BOGUS);
            SetDlgItemInt(Dialog, 101, Width, TRUE);
            return TRUE;
            }
        HANDLE_MSG(Dialog, WM_COMMAND, MainDialogCommand);
        case    WM_NOTIFY       :
            {
            NMHDR *Head = (NMHDR*)lParam;
            HWND    Win = Head->hwndFrom;

            if(Head->code == NM_CLICK && IsDlgButtonChecked(Dialog, 103))
                {
                POINT   Mouse;
                GetCursorPos(&Mouse);
                ScreenToClient(Win, &Mouse);
                LV_HITTESTINFO  HitTest;
                HitTest.pt      = Mouse;
                ListView_HitTest(Win, &HitTest);
                int Width = ListView_GetColumnWidth(Win, 0);
                // if outside of item text but in first column
                if(!(HitTest.flags & LVHT_ONITEM) && HitTest.pt.x <= Width)
                    {
                    // force the hit to work if on a valid line
                    HitTest.pt.x    = 1;
                    ListView_HitTest(Win, &HitTest);
                    if(HitTest.flags & LVHT_ONITEM)
                        ListView_SetItemState(Win, HitTest.iItem, 
                            LVIS_FOCUSED|LVIS_SELECTED, LVIS_FOCUSED|LVIS_SELECTED);
                    }
                }

            else if(wParam == 104 && Head->code == LVN_BEGINLABELEDIT)
                return SetDlgMsgResult(Dialog, WM_NOTIFY, FALSE); // allow label editing
            else if(wParam == 104 && Head->code == LVN_ENDLABELEDIT)
                {
                ListView_SortItems(GetDlgItem(Dialog, 104), SortFunc, 0);
                return SetDlgMsgResult(Dialog, WM_NOTIFY, 1);
                }
            return FALSE;
            break;
            }
        }
    return FALSE; /* FALSE == we did not process msg */
    }

#ifdef __BORLANDC__
    #pragma argsused
#endif
int WINAPI WinMain(HINSTANCE Instance, HINSTANCE Previous,
        LPSTR CommandLine, int ShowCommand)
    {
    InitCommonControls();
    CurrentInstance    = Instance;
    DialogBox(CurrentInstance, MAIN_DLG, NULL, MainDialog);
    return 0;
    }

