// =========================================================
// tracex implementation
// =========================================================
#include "stdafx.h"        // possibly needed for PCH
#include "tracex.h"

// static members
// --------------
int  CTracex::mIndent = 0;
BOOL CTracex::mTracing = TRUE;

// =========================================================
// CTracex constructor
// =========================================================
CTracex::CTracex(CString pMsg)
 {// Remember the message string
  // ---------------------------
  mMsg = pMsg;

  // If we are tracing, display a trace
  // ----------------------------------
  if (mTracing == TRUE)
   {traceIndent();
    TRACE(pMsg + "\n");
   }

  // Move the indentation level up a notch
  // -------------------------------------
  mIndent += 2;
 }

// =========================================================
// CTracex destructor
// =========================================================
CTracex::~CTracex()
 {ASSERT_VALID(this);

  // Move the indentation level back down a notch
  // --------------------------------------------
  mIndent -= 2;
  
  // If we are tracing, display the trace exit message
  // -------------------------------------------------
  if (mTracing == TRUE)
   {traceIndent();
    mMsg += " exit\n";
    TRACE(mMsg);
   }
 }

// =========================================================
// AssertValid
// Inherited from CObject.
// =========================================================
void CTracex::AssertValid() const
 {CObject::AssertValid();
 }

// =========================================================
// traceIndent
// Used privately to display an indentation
// =========================================================
void CTracex::traceIndent()
 {ASSERT_VALID(this);

  if (mTracing == TRUE)
   {if (mIndent > 0)

     // crude but effective
     // -------------------
     {for (int tCount = 0; tCount < mIndent; tCount++)
       TRACE0(" ");
     }
   }
 }
 
// =========================================================
// msg
// Use this to display a message at the current indentation
// level
// =========================================================
void CTracex::msg(const CString pMsg)
 {ASSERT_VALID(this);

  if (mTracing == TRUE)  
   {traceIndent();
    TRACE(mMsg);
    TRACE0(" : ");  
    TRACE((pMsg.GetLength() > 511) ? pMsg.Left(511) : pMsg);

    TRACE0("\n");
   }
 }

// =========================================================
// msg (overloaded)
// Displays a CString and an int
// =========================================================
void CTracex::msg(const CString pMsg, const int pInt)
 {ASSERT_VALID(this);
  
  char tStr[10]={0};
  itoa(pInt, tStr, 10);
  msg(pMsg + (CString)tStr);
 }

// =========================================================
// msg (overloaded)
// Displays a CString and an unsigned int
// =========================================================
void CTracex::msg(const CString pMsg, 
                  const unsigned int pUint)
 {ASSERT_VALID(this);
  msg(pMsg, (unsigned long)pUint);
 }

// =========================================================
// msg (overloaded)
// Displays a CString and a long
// =========================================================
void CTracex::msg(const CString pMsg, const long pLong)
 {ASSERT_VALID(this);
  
  char tStr[30]={0};
  ltoa(pLong, tStr, 10);
  msg(pMsg + (CString)tStr);
 }

// =========================================================
// msg (overloaded)
// Displays a CString and an unsigned long
// =========================================================
void CTracex::msg(const CString pMsg, 
                  const unsigned long pUlong)
 {ASSERT_VALID(this);
  
  char tStr[30]={0};
  ultoa(pUlong, tStr, 10);
  msg(pMsg + (CString)tStr);
 }

// =========================================================
// msg (overloaded)
// Displays a CString and a double
// NOTE: I have arbitrarilly chosen to display only seven
// digits to the right of the decimal.
// =========================================================
void CTracex::msg(const CString pMsg, const double pDouble)
 {ASSERT_VALID(this);
  
  int decimal, sign;
  char* tStr;
  tStr = _fcvt(pDouble, 7, &decimal, &sign);

  // _fcvt doesn't do the formatting of the sign and the 
  // decimal so we must do that here.
  // ---------------------------------------------------
  CString tString = "";
  const CString tDot = ".";

  if (sign != 0)
   tString = (CString)"-";

  if (decimal < 1)
   {tString += tDot;

    for (int tSub = 0; tSub > decimal; tSub--)
     tString += (CString)"0";

    tString += (CString)tStr;
   }

  else if (decimal >= (int)strlen(tStr))
   tString += (CString)tStr + tDot;

  else
   {for (int tSub = 0; tSub < decimal; tSub++)
     tString += tStr[tSub];

    tString += tDot;

    for (tSub = decimal; tSub < (int)strlen(tStr); tSub++)
     tString += tStr[tSub];
   }

  msg(pMsg + tString);
 }

// =========================================================
// msg (overloaded)
// Displays a CString and another CString
// =========================================================
 void CTracex::msg(const CString pMsg, 
                   const CString pString)
  {ASSERT_VALID(this);
  
   msg(pMsg + pString);
  }

// =========================================================
// msg (overloaded)
// Displays a CString and calls the CObject*'s Dump() 
// member.
// =========================================================
 void CTracex::msg(const CString pMsg,
                   const CObject* pObject)
  {ASSERT_VALID(this);
  
   CString tSep = "==========";
   msg(tSep + " " + pMsg + " dump " + tSep);

   #ifdef _DEBUG
   pObject->Dump(afxDump);
   #endif

   msg(tSep + " end of " + pMsg + " dump " + tSep);
  }
