//
// MAR97.CPP
//
// This program demonstrates a problem with
// Borland C++ 5.0.  The draft ISO/ANSI
// specification indicates that automatic
// objects will have their destructors called
// upon the exit of their scope, regardless of
// how the exit is accomplished.  This program
// shows that BC++ skips the destructor call
// when the scope is exited via a goto.
//

#include <iostream.h>

class Test {
public:
    Test(){ cout << "Test ctor\n"; }
    ~Test(){ cout << "Test dtor\n"; }
};

void foo( int i )
{
    cout << "\nEntering foo with i = "
         << i
         << "\n";
    {
        Test t;
        if ( i )
            goto exit;
    }
exit:
    cout << "Leaving foo\n";
}

int main()
{
    foo( 0 );
    foo( 1 );
    return 0;
}
//EOF
