// app.c

#include <windows.h>
#include <winioctl.h>
#include <stdio.h>
#include "wdj.h"

VOID __cdecl main(void)
{
    HANDLE driver = NULL, event = NULL;
    ULONG  size = 0;
    WDJ_DATA Data;
    char Buffer[128];

    Data.Event = CreateEvent(NULL, TRUE, FALSE, NULL);
    Data.BufferSize = 128;
    Data.Buffer = Buffer;

    driver = CreateFile("\\\\.\\wdjdrv", GENERIC_READ | GENERIC_WRITE,
                        FILE_SHARE_READ | FILE_SHARE_WRITE, NULL,
                        OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

    if (driver == INVALID_HANDLE_VALUE) {
        printf("Error opening wdj Driver (%d)\n", GetLastError());
        return;
    }

    //
    // Pass the event and buffer to the driver and then wait.
    //
    if (!DeviceIoControl(driver, (DWORD)IOCTL_WDJ_REQUEST,
                         (LPBYTE)(&Data), sizeof(WDJ_DATA), NULL, 0,
                         &size, NULL)) {

        printf("IOCTL_WDJ_REQUEST, Error %d\n", GetLastError());
        return;
    }

    WaitForSingleObject(Data.Event, INFINITE);

    CloseHandle(Data.Event);
    CloseHandle(driver);

    printf("IOCTL_WDJ_REQUEST returned %s\n", Data.Buffer);
}

