// disable some warnings:

// "signed/unsigned mismatch"
#pragma warning(disable: 4018)

// "nonstandard extension used : redefined extern to static"
#pragma warning(disable: 4211)

// "identifier truncated to '255' characters in browser information"
#pragma warning(disable: 4786)

#if _MSC_VER == 1010
 #define NOMINMAX      // Skip min()/max() macros in <windef.h>
 #include <typeinfo.h>
 #include <mystl.h>    // That is, Microsoft's header corrected
#else
 #include <typeinfo>  // Standard C++ header
 #include <stl.h>    // That is, Microsoft's header corrected
 #include <iostream> // Standard C++ header
#endif

#include <afxwin.h>
#include <afxtempl.h>

typedef CArray<CString, const CString&>          MFCA;
typedef CList<CString, const CString&>           MFCL;
typedef CMap<INT,INT,CString,CString&>           MFCM;

#if _MSC_VER == 1010
 typedef std::vector<CString>                     STLV;
 typedef std::list<CString>                       STLL;
 typedef std::map<INT, CString, std::less<CHAR> > STLM;
#else 
 typedef vector<CString>                          STLV;
 typedef list<CString>                            STLL;
 typedef map<INT, CString, less<CHAR> >           STLM;
#endif

class MyList : public STLL, public MFCL{
 DECLARE_DYNAMIC(MyList)
public:
 POSITION AddTail(LPCTSTR _a){
  STLL::push_back(_a);
  return MFCL::AddTail(_a);
 }
 void push_back(LPCTSTR _a){
  MFCL::AddTail(_a);
  STLL::push_back(_a);
 }
} MySplitObject;

IMPLEMENT_DYNAMIC(MyList, CObject)

// MFC collection class templates
MFCA MfcArray;
MFCL MfcList;
MFCM MfcMap;

// STL collection class templates
STLV StlVector;
STLL StlList;
STLM StlMap;

void DisplayMfcArray();
void DisplayMfcList();
void DisplayMfcMap();

void DisplayStlVector();
void DisplayStlList();
void DisplayStlMap();

void DisplayStlVectorWithSTLAlgo();
void DisplayMySplitObject();

void  main(){
 #ifdef _DEBUG
  afxMemDF |= allocMemDF | checkAlwaysMemDF;
 #endif
 
 const CString string1(_T("const string1"));

 // Add string1 to MFC classes
 MfcArray.Add(string1);
 MfcList.AddTail(string1);
 MfcMap[0] = string1;

 // Add string to STL classes
 StlVector.push_back(string1);
 StlList.push_back(string1);
 StlMap[0] = string1;

 CString string2(_T("string2"));

 // Add string2 to MFC classes
 MfcArray.Add(string2);
 MfcList.AddTail(string2);
 MfcMap[1] = string2;

 // Add string2 to STL classes
 StlVector.push_back(string2);
 StlList.push_back(string2);
 StlMap[1] = string2;

 DisplayMfcArray();
 DisplayMfcList();
 DisplayMfcMap();

 DisplayStlVector();
 DisplayStlList();
 DisplayStlMap();

// Use an STL algorithm on a MFC collection class template

// Count number of times letter '1' appears in string contained
// in MfcArray[0]
  INT n=0; // must be initialized
  INT len = MfcArray[0].GetLength();
  #if _MSC_VER == 1010
   std::count((LPCTSTR)MfcArray[0],
        (LPCTSTR)MfcArray[0]+len, _T('1'), n);
  #else
   n = count((LPCTSTR)MfcArray[0],
        (LPCTSTR)MfcArray[0]+len, _T('1') );
  #endif
  cout << "The letter '1' appears " << n
    << " time(s) in " << (LPCTSTR)MfcArray[0] << endl;

 
 // Use STL algorithms on STL collection class templates
  // copy() used on StlVector
  DisplayStlVectorWithSTLAlgo();

  // fill_n() used on StlVector
  #if _MSC_VER == 1010
   std::fill_n(StlVector.begin(), StlVector.size(),
        _T("fill_n() used to replace strings in StlVector"));
  #else
   fill_n(StlVector.begin(), StlVector.size(),
        _T("fill_n() used to replace strings in StlVector"));
  #endif
  DisplayStlVector();
  
  // reverse() used on StlList
  cout << "***Reversing contents of StlList" << endl;
  StlList.reverse();
  DisplayStlList();

  // insert() used on StlMap
  cout << "***Inserting new string in StlMap" << endl;
  #if _MSC_VER == 1010
   StlMap.insert(std::pair<const INT, const CString>
        (2, "insert()ed string"));
  #else
   StlMap.insert(pair<const INT, const CString>
        (2, "insert()ed string"));
  #endif
  DisplayStlMap();

 // MyList is part CList and part std::list 
 MySplitObject.push_back(_T("push_back() string"));
 MySplitObject.AddTail(_T("AddTail() string"));
 DisplayMySplitObject();

 cout << "Emptying MySplitObject's CList part" << endl;
 MySplitObject.RemoveAll();
 cout << "MySplitObject's CList part has " <<
    MySplitObject.GetCount() << " items" << endl;
 cout << "MySplitObject's std::list part has "
    << MySplitObject.size() << " items" << endl;

 ASSERT(MySplitObject.IsKindOf(RUNTIME_CLASS(MyList)));
 CRuntimeClass *prt = MySplitObject.GetRuntimeClass();
 cout << "MySplitObject's CRunTimeClass name is: "
    << prt->m_lpszClassName << endl;
 cout << "MySplitObject's typeinfo.name() is: "
    << typeid(MySplitObject).name() << endl;  

 MySplitObject.Dump(afxDump);
 MySplitObject.AssertValid();
 }

void DisplayMfcArray(){
 const INT iMfcArraySize = MfcArray.GetSize();
 for(INT i=0; i<iMfcArraySize; i++)
  cout << "MfcArray["<<i<<"] = " << MfcArray[i] << endl;
}

void DisplayMfcList(){
 POSITION pos = MfcList.GetHeadPosition(); 
 while(pos)
  cout << "MfcList contains " << MfcList.GetNext(pos) << endl;
}

void DisplayMfcMap(){
 POSITION pos = MfcMap.GetStartPosition();
 INT key;
 CString val;
 while(pos){
  MfcMap.GetNextAssoc(pos, key, val);
  cout << "MfcMap " << key << " is " << val << endl;
 }
}

void DisplayStlVector(){
 const INT iStlVectorSize = StlVector.size();
 for(INT i=0; i<iStlVectorSize; i++)
  cout << "StlVector[" <<i<< "] = " << StlVector[i] << endl;
}

void DisplayStlList(){
 STLL::iterator iter_StlList;
 for(iter_StlList = StlList.begin(); iter_StlList != StlList.end();
        iter_StlList++)
  cout << "StlList contains " << *iter_StlList << endl;
}

void DisplayStlMap(){
 STLM::iterator it;
 for(it = StlMap.begin(); it != StlMap.end(); it++)
  cout << "StlMap " << ((*it).first) << " is "
    << ((*it).second) << endl;
}

void DisplayStlVectorWithSTLAlgo(){
 cout << "*** Displaying contents StlVector with copy **" << endl;
 #if _MSC_VER == 1010
  std::ostream_iterator<CString> iter (cout, "\n\r");
  std::copy(StlVector.begin(), StlVector.end(), iter);
 #else
  ostream_iterator<CString, CHAR, struct char_traits<CHAR> >
    iter (cout, "\n\r");
  copy(StlVector.begin(), StlVector.end(), iter);
 #endif
}

void DisplayMySplitObject(){
 cout << "*** CList part of MyList **" << endl;
 POSITION pos = MySplitObject.GetHeadPosition(); 
 while(pos)
  cout << "MyList contains " << MySplitObject.GetNext(pos) << endl;

 cout << "*** std::list part of MyList **" << endl;
 MyList::iterator MyIter;
 for(MyIter = MySplitObject.begin();
        MyIter != MySplitObject.end(); MyIter++)
  cout << "MyList contains " << *MyIter << endl; 
}


