//
// WaitCurs.cpp: Implementation
// 

...
#include "WaitCursor.h"

WaitCursor::~WaitCursor() // Forces a WM_SETCURSOR message.
{
 CPoint pt; // Screen coordinates!

#ifdef _WIN32
 if ( !::GetCursorPos(&pt) )
  TRACE0("WaitCursor::~WaitCursor(): GetCursorPos Failed\n");
 else if ( !::SetCursorPos(pt.x, pt.y) )
  TRACE2("WaitCursor::~WaitCursor(): "
         "SetCursorPos(%d,%d) Failed\n",
         pt.x, pt.y);
#else // Win16
 ::GetCursorPos(&pt);
 ::SetCursorPos(pt.x, pt.y);
#endif
}


