// netnode.h

#ifndef _NETNODE_H_
#define _NETNODE_H

#include <winnetwk.h> // network APIs

class CNetNode
{
public:
  // construction/destruction
  CNetNode();
  CNetNode(LPNETRESOURCE pNetResource);
  ~CNetNode();

  // network enumeration
  DWORD EnumerateNetwork();
  inline DWORD GetChildCount()
    { return(m_nodeCount); }
  inline CNetNode * GetChildNode(DWORD index)
    { return(m_nodeArray[index]); }

  // query network node details
  inline BOOL IsContainer()
    { return(m_pNetResource->dwUsage &
      RESOURCEUSAGE_CONTAINER); }
  inline const char * GetText()
    { return(m_text); }
  inline const char * GetLocalName()
    { return(m_pNetResource->lpLocalName); }
  inline const char * GetRemoteName()
    { return(m_pNetResource->lpRemoteName); }
  inline const char * GetComment()
    { return(m_pNetResource->lpComment); }
  inline const char * GetProvider()
    { return(m_pNetResource->lpProvider); }
  inline DWORD GetScope()
    { return(m_pNetResource->dwScope); }
  inline DWORD GetType()
    { return(m_pNetResource->dwType); }
  inline DWORD GetDisplayType()
    { return(m_pNetResource->dwDisplayType); }
  inline DWORD GetUsage()
    { return(m_pNetResource->dwUsage); }

  // platform utility
  static inline int GetPlatformID()
    { if (m_platformID >= 0) return(m_platformID);
      else return(InitPlatformID()); }
  static inline int PlatformIsWindows95()
    { return(GetPlatformID() == 
      VER_PLATFORM_WIN32_WINDOWS); }
  static inline int PlatformIsWindowsNT()
    { return(GetPlatformID() ==
      VER_PLATFORM_WIN32_NT); }

protected:
  void EnumerateWin95NetProviders(char *
    pNetProviders, DWORD * pNumNetProviders);
  DWORD EnumerateNetworkWin95Root();
  static int InitPlatformID();

  static int      m_platformID;
  BOOL            m_isRoot;
  BOOL            m_haveEnumerated;
  char *          m_text;
  CNetNode **     m_nodeArray;
  DWORD           m_nodeCount;
  LPNETRESOURCE   m_pNetResource;
};

#endif // _NETNODE_H
