// browsdlg.cpp

#include "stdafx.h"
#include "netbrows.h"
#include "netnode.h"
#include "browsdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

class CAboutDlg : public CDialog
{
public:
  CAboutDlg();

  //{{AFX_DATA(CAboutDlg)
  enum { IDD = IDD_ABOUTBOX };
  //}}AFX_DATA

  //{{AFX_VIRTUAL(CAboutDlg)
  protected:
  virtual void DoDataExchange(CDataExchange* pDX);
  //}}AFX_VIRTUAL

protected:
  //{{AFX_MSG(CAboutDlg)
  //}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
  //{{AFX_DATA_INIT(CAboutDlg)
  //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CAboutDlg)
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
  //{{AFX_MSG_MAP(CAboutDlg)
    // No message handlers
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()


CNetbrowsDlg::CNetbrowsDlg(CWnd* pParent /*=NULL*/)
  : CDialog(CNetbrowsDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CNetbrowsDlg)
  m_comment = _T("");
  m_localName = _T("");
  m_remoteName = _T("");
  m_displayType = _T("");
  m_provider = _T("");
  m_scope = _T("");
  m_type = _T("");
  m_usage = _T("");
  //}}AFX_DATA_INIT
  m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetbrowsDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CNetbrowsDlg)
  DDX_Control(pDX, IDC_TREE, m_tree);
  DDX_Text(pDX, IDC_COMMENT, m_comment);
  DDX_Text(pDX, IDC_LOCAL_NAME, m_localName);
  DDX_Text(pDX, IDC_REMOTE_NAME, m_remoteName);
  DDX_Text(pDX, IDC_DISPLAY_TYPE, m_displayType);
  DDX_Text(pDX, IDC_PROVIDER, m_provider);
  DDX_Text(pDX, IDC_SCOPE, m_scope);
  DDX_Text(pDX, IDC_TYPE, m_type);
  DDX_Text(pDX, IDC_USAGE, m_usage);
  //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetbrowsDlg, CDialog)
  //{{AFX_MSG_MAP(CNetbrowsDlg)
  ON_WM_SYSCOMMAND()
  ON_WM_QUERYDRAGICON()
  ON_NOTIFY(TVN_ITEMEXPANDING, IDC_TREE,
    OnItemexpandingTree)
  ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, OnSelchangedTree)
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CNetbrowsDlg::OnInitDialog()
{
  CDialog::OnInitDialog();

  // Add "About..." menu item to system menu.
  CMenu* pSysMenu = GetSystemMenu(FALSE);
  CString strAboutMenu;
  strAboutMenu.LoadString(IDS_ABOUTBOX);
  if (!strAboutMenu.IsEmpty())
  {
    pSysMenu->AppendMenu(MF_SEPARATOR);
    pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX,
      strAboutMenu);
  }

  // Set the icon for this dialog
  SetIcon(m_hIcon, TRUE);      // Set big icon
  SetIcon(m_hIcon, FALSE);    // Set small icon

  CreateRootNode();
  
  return TRUE;
}

BOOL CNetbrowsDlg::DestroyWindow() 
{
  delete m_pRootNode;
  return CDialog::DestroyWindow();
}

void CNetbrowsDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
  if ((nID & 0xFFF0) == IDM_ABOUTBOX)
  {
    CAboutDlg dlgAbout;
    dlgAbout.DoModal();
  }
  else
  {
    CDialog::OnSysCommand(nID, lParam);
  }
}

// NOTE: If you add a minimize button to this dialog,
// you will need to handle OnPaint() to draw the icon.

// The system calls this to obtain the cursor to display
// while the user drags the minimized window.
HCURSOR CNetbrowsDlg::OnQueryDragIcon()
{
  return (HCURSOR) m_hIcon;
}

void CNetbrowsDlg::CreateRootNode()
{
  // Create the root network node (use default constructor)
  m_pRootNode = new CNetNode;
  // Add root node to tree
  AddNodeToTree(m_pRootNode, TVI_ROOT);
  UpdateDisplay(NULL);
}

void CNetbrowsDlg::AddNodeToTree(CNetNode *pNode,
  HTREEITEM parent)
{
  TV_INSERTSTRUCT    tvIns = { 0 };

  tvIns.hParent = parent;
  tvIns.hInsertAfter = TVI_SORT;
  tvIns.item.mask = TVIF_TEXT | TVIF_CHILDREN | TVIF_PARAM;

  // It is safe to cast away the const-ness here because
  // we do not allow the tree labels to be edited
  tvIns.item.pszText =
    (char *) ((const char *)pNode->GetText());

  if (pNode->IsContainer())
    tvIns.item.cChildren = 1;
  tvIns.item.lParam = (LPARAM) pNode;

  HTREEITEM hItem = m_tree.InsertItem(&tvIns);
}

void CNetbrowsDlg::OnItemexpandingTree(NMHDR* pNMHDR,
  LRESULT* pResult) 
{
  NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
  
  LPTV_ITEM pParent = &pNMTreeView->itemNew;

  // Assume we will return FALSE,
  // allowing the expansion to occur
  *pResult = FALSE;

  // If the action is NOT expand, or if we have
  // already expanded at least once, we don't need
  // to do anything here
  if ( pNMTreeView->action != TVE_EXPAND ||
       (pParent->state & TVIS_EXPANDEDONCE) )
    return;

  // Get a handle to the parent item
  TV_ITEM    tvItem;
  tvItem.hItem = pParent->hItem;
  tvItem.mask = TVIF_HANDLE;
  m_tree.GetItem(&tvItem);

  // We are expanding an item for the first time
  // Enumerate its children and add them to the tree
  DWORD   numChildren = 0;
  DWORD   ret = 0;

  CNetNode * pParentNode = (CNetNode *) pParent->lParam;

  {
    CWaitCursor  wc;  // display hourglass cursor
    ret = pParentNode->EnumerateNetwork();
  }

  if (ret)
  {
    static const DWORD maxMsgLen = 1024;
    CString errMsg;
    char * pMsgBuf = errMsg.GetBuffer(maxMsgLen);

    DWORD formatRet = FormatMessage(
      FORMAT_MESSAGE_IGNORE_INSERTS |
      FORMAT_MESSAGE_FROM_SYSTEM,
      NULL, ret, 0, pMsgBuf, maxMsgLen, NULL);

    errMsg.ReleaseBuffer();

    if (formatRet == 0)
      errMsg.Format("Network enumeration failed.  \n\n"
      "Error code: %lu.", ret);

    MessageBox(errMsg, "Error",
     MB_ICONEXCLAMATION | MB_OK);
  }
  else
  {
    CNetNode * pChildNode;
    numChildren = pParentNode->GetChildCount();

    for (DWORD i = 0; i < numChildren; i++)
    {
      pChildNode = pParentNode->GetChildNode(i);
      AddNodeToTree(pChildNode, tvItem.hItem);
    }
  }

  // If there are no child items, or an error occurred,
  // remove the "+" from the parent item by indicating
  // it has no child items
  if (ret || numChildren == 0)
  {
    tvItem.mask |= TVIF_CHILDREN;
    tvItem.cChildren = 0;
    m_tree.SetItem(&tvItem);

    // indicate that tree expansion should NOT occur
    *pResult = TRUE;
  }
}

void CNetbrowsDlg::OnSelchangedTree(NMHDR* pNMHDR,
  LRESULT* pResult) 
{
  NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
  LPTV_ITEM pNewItem = &pNMTreeView->itemNew;
  UpdateDisplay(pNewItem);
  *pResult = 0;
}

void CNetbrowsDlg::UpdateDisplay(LPTV_ITEM pItem)
{
  CNetNode * pNode;

  if (pItem == NULL)
    pNode = m_pRootNode;
  else
    pNode = (CNetNode *) pItem->lParam;

  // Get text items from net node
  m_localName = pNode->GetLocalName();
  m_remoteName = pNode->GetRemoteName();
  m_comment = pNode->GetComment();
  m_provider = pNode->GetProvider();

  // Get numeric items from net node
  DWORD scope = pNode->GetScope();
  DWORD type = pNode->GetType();
  DWORD displayType = pNode->GetDisplayType();
  DWORD usage = pNode->GetUsage();

  // Convert numeric codes to text for display
  if (scope == RESOURCE_CONNECTED)
      m_scope = "CONNECTED";
  else if (scope == RESOURCE_GLOBALNET)
      m_scope = "GLOBALNET";
  else if (scope == RESOURCE_REMEMBERED)
      m_scope = "REMEMBERED";
#if(WINVER >= 0x0400)
  else if (scope == RESOURCE_RECENT)
      m_scope = "RECENT";
  else if (scope == RESOURCE_CONTEXT)
      m_scope = "CONTEXT";
#endif // WINVER >= 0x0400

  if (type == RESOURCETYPE_UNKNOWN)
    m_type = "UNKNOWN";
  else
  {
    m_type = "";
    if (type & RESOURCETYPE_ANY)
      m_type += "ANY ";
    if (type & RESOURCETYPE_DISK)
      m_type += "DISK ";
    if (type & RESOURCETYPE_PRINT)
      m_type += "PRINT ";
  }
    
  if (displayType == RESOURCEDISPLAYTYPE_GENERIC)
    m_displayType = "GENERIC";
  else if (displayType == RESOURCEDISPLAYTYPE_DOMAIN)
    m_displayType = "DOMAIN";
  else if (displayType == RESOURCEDISPLAYTYPE_SERVER)
    m_displayType = "SERVER";
  else if (displayType == RESOURCEDISPLAYTYPE_SHARE)
    m_displayType = "SHARE";
  else if (displayType == RESOURCEDISPLAYTYPE_FILE)
    m_displayType = "FILE";
  else if (displayType == RESOURCEDISPLAYTYPE_GROUP)
    m_displayType = "GROUP";
#if(WINVER >= 0x0400)
  else if (displayType == RESOURCEDISPLAYTYPE_NETWORK)
    m_displayType = "NETWORK";
  else if (displayType == RESOURCEDISPLAYTYPE_ROOT)
    m_displayType = "ROOT";
  else if (displayType == RESOURCEDISPLAYTYPE_SHAREADMIN)
    m_displayType = "SHAREADMIN";
  else if (displayType == RESOURCEDISPLAYTYPE_DIRECTORY)
    m_displayType = "DIRECTORY";
#endif /* WINVER >= 0x0400 */
  else if (displayType == RESOURCEDISPLAYTYPE_TREE)
    m_displayType = "TREE";

  m_usage = "";
#if(WINVER >= 0x0400)
  if ((usage & RESOURCEUSAGE_ALL) == RESOURCEUSAGE_ALL)
    m_usage += "ALL ";
  else
#endif
  {
    if (usage & RESOURCEUSAGE_CONNECTABLE)
      m_usage += "CONNECTABLE ";
    if (usage & RESOURCEUSAGE_CONTAINER)
      m_usage += "CONTAINER ";
  }

  if (usage & RESOURCEUSAGE_NOLOCALDEVICE)
    m_usage += "NOLOCALDEVICE ";
  if (usage & RESOURCEUSAGE_SIBLING)
    m_usage += "SIBLING ";

  UpdateData(FALSE);  // copy member variables to screen
}
