
// __________________________________________________________
//
//                         DevLoad.c
//           Kernel-Mode Device Driver Loader V1.00
//                11-16-1996 Sven B. Schreiber
//                 100557.177@compuserve.com
// __________________________________________________________

#include <windows.h>
#include <cuistart.h>

// =================================================================
// DATA TYPES
// =================================================================

typedef SC_HANDLE *PSC_HANDLE;

// =================================================================
// ERROR HANDLER
// =================================================================

void Error (PSTR psErrorMessage)
    {
    PVOID pBuffer;
    DWORD dError = GetLastError ();

    pBuffer = NULL;
    FormatMessage (FORMAT_MESSAGE_FROM_SYSTEM
                 | FORMAT_MESSAGE_ALLOCATE_BUFFER
                 | FORMAT_MESSAGE_IGNORE_INSERTS,
                   NULL,
                   dError,
                   MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT),
                   (PSTR) &pBuffer,
                   0,
                   NULL);

    printf ("ERROR 0x%08X\n", dError);

    if (pBuffer != NULL)
        {
        printf ("!! %s", pBuffer);
        LocalFree (pBuffer);
        }
    printf (psErrorMessage);
    return;
    }

// -----------------------------------------------------------------

void Status (BOOL fOk,
             PSTR psErrorMessage)
    {
    if (fOk)
        {
        printf ("OK");
        }
    else
        {
        Error (psErrorMessage);
        }
    return;
    }

// =================================================================
// DEVICE HANDLING
// =================================================================

BOOL OpenDevice (SC_HANDLE  hControl,
                 PSTR       psDeviceName,
                 PSC_HANDLE phService)
    {
    BOOL fOk;

    printf ("\n   Opening:  Device \"%s\" ... ", psDeviceName);
    fOk = ((*phService = OpenService (hControl,
                                      psDeviceName,
                                      SERVICE_ALL_ACCESS))
           != NULL);

    Status (fOk, "!! Device not opened.");
    return fOk;
    }

// -----------------------------------------------------------------

BOOL CloseDevice (SC_HANDLE  hControl,
                  PSTR       psDeviceName,
                  PSC_HANDLE phService)
    {
    BOOL fOk;

    printf ("\n   Closing:  Device \"%s\" ... ", psDeviceName);
    fOk = CloseServiceHandle (*phService);
    Status (fOk, "!! Device not closed.");
    *phService = NULL;
    return fOk;
    }

// -----------------------------------------------------------------

BOOL CreateDevice (SC_HANDLE hControl,
                   PSTR      psDeviceName,
                   PSTR      psDisplayName,
                   PSTR      psDriverPath)
    {
    SC_HANDLE hService;
    BOOL      fOk;

    printf ("\n   Driver:   \"%s\"", psDriverPath);
    printf ("\n   Creating: Device \"%s\" ... ", psDeviceName);
    fOk = ((hService = CreateService (hControl,
                                      psDeviceName,
                                      psDisplayName,
                                      SERVICE_ALL_ACCESS,
                                      SERVICE_KERNEL_DRIVER,
                                      SERVICE_DEMAND_START,
                                      SERVICE_ERROR_NORMAL,
                                      psDriverPath,
                                      NULL,
                                      NULL,
                                      NULL,
                                      NULL,
                                      NULL))
           != NULL);
    
    Status (fOk, "!! Device not created.");
    if (fOk)
        {
        CloseDevice (hControl, psDeviceName, &hService);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL RemoveDevice (SC_HANDLE hControl,
                   PSTR      psDeviceName)
    {
    SC_HANDLE hService;
    BOOL      fOk;

    fOk = OpenDevice (hControl, psDeviceName, &hService);
    if (fOk)
        {
        printf ("\n   Removing: Device \"%s\" ... ", psDeviceName);
        fOk = DeleteService (hService);
        Status (fOk, "!! Device not removed.");
        CloseDevice (hControl, psDeviceName, &hService);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL StartDevice (SC_HANDLE hControl,
                  PSTR      psDeviceName)
    {
    SC_HANDLE hService;
    BOOL      fOk;

    fOk = OpenDevice (hControl, psDeviceName, &hService);
    if (fOk)
        {
        printf ("\n   Starting: Device \"%s\" ... ", psDeviceName);
        fOk = StartService (hService, 0, NULL);
        Status (fOk, "!! Device not started.");
        CloseDevice (hControl, psDeviceName, &hService);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL StopDevice (SC_HANDLE hControl,
                 PSTR      psDeviceName)
    {
    SC_HANDLE      hService;
    SERVICE_STATUS ServiceStatus;
    BOOL           fOk;

    fOk = OpenDevice (hControl, psDeviceName, &hService);
    if (fOk)
        {
        printf ("\n   Stopping: Device \"%s\" ... ", psDeviceName);
        fOk = ControlService (hService,
                              SERVICE_CONTROL_STOP,
                              &ServiceStatus);
        Status (fOk, "!! Device not stopped.");
        CloseDevice (hControl, psDeviceName, &hService);
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL LoadDriver (SC_HANDLE hControl,
                 PSTR      psDeviceName,
                 PSTR      psDisplayName,
                 PSTR      psDriverPath)
    {
    BOOL fOk;

    fOk = CreateDevice (hControl,
                        psDeviceName,
                        psDisplayName,
                        psDriverPath);
    if (fOk)
        {
        fOk = StartDevice (hControl,
                           psDeviceName);
        if (!fOk)
            {
            RemoveDevice (hControl,
                          psDeviceName);
            }
        }
    return fOk;
    }

// -----------------------------------------------------------------

BOOL UnloadDriver (SC_HANDLE hControl,
                   PSTR      psDeviceName)
    {
    BOOL fOk;

    fOk = StopDevice (hControl,
                      psDeviceName);

    fOk = RemoveDevice (hControl,
                        psDeviceName) && fOk;
    return fOk;
    }

// =================================================================
// MAIN PROGRAM
// =================================================================

void main (int argc, char *argv [], char *envp [])
    {
    SC_HANDLE hControl;
    char      sDriverPath [MAX_PATH];
    PSTR      psDriverFile;
    BOOL      fOk;

    printf ("\n// Kernel-Mode Device Driver Loader V1.00"
            "\n// 11-16-1996 Sven B. Schreiber"
            "\n// 100557.177@compuserve.com\n");

    if (argc != 3)
        {
        printf ("\n   Usage:  DevLoad <device name> <driver path>"
                "\n      or:  DevLoad <device name> /unload");
        }
    else
        {
        printf ("\n   Opening:  Service Control Manager ... ");
        fOk = ((hControl = OpenSCManager (NULL,
                                          NULL,
                                          SC_MANAGER_ALL_ACCESS))
               != NULL);

        Status (fOk, "!! Service Control Manager not opened.");
        if (fOk)
            {
            if (lstrcmpi (argv [2], "/unload"))
                {
                GetFullPathName (argv [2],
                                 MAX_PATH,
                                 sDriverPath,
                                 &psDriverFile);

                LoadDriver (hControl,
                            argv [1],
                            argv [1],
                            sDriverPath);
                }
            else
                {
                UnloadDriver (hControl,
                              argv [1]);
                }
            printf ("\n   Closing:  Service Control Manager ... ");
            fOk = CloseServiceHandle (hControl);
            Status (fOk, "!! Service Control Manager not closed.");
            }
        }
    printf ("\n");
    return;
    }

// =================================================================
// END OF PROGRAM
// =================================================================
