    
// __________________________________________________________
//
//                         CuiStart.h
//        Startup Code for Win32 Console Applications
//                09-20-1996 Sven B. Schreiber
//                 100557.177@compuserve.com
// __________________________________________________________
    


// =================================================================
// CONSTANTS
// =================================================================

#define EOF (-1)
    
// =================================================================
// GLOBAL VARIABLES
// =================================================================

HANDLE hStdIn, hStdOut, hStdErr;
    
// =================================================================
// PROTOTYPES
// =================================================================

void main (int argc, char *argv [], char *envp []);
    
// =================================================================
// STARTUP CODE
// =================================================================

void WinStartup ()
    {
    PVOID  pvBuffer;
    PSTR   psCmdLine, psEnvStrings;
    PSTR   *argv, *envp, cmdp;
    int    argc, envc;
    char   cQuote;

    psCmdLine = GetCommandLine ();
    argc = 0;
    while (TRUE)
        {
        while (*psCmdLine++ == ' ');
        cQuote = (*--psCmdLine == '"' ? *psCmdLine++ : ' ');
        if (!*psCmdLine) break;
        argc++;
        while (*psCmdLine && (*psCmdLine++ != cQuote));
        }
    psEnvStrings = GetEnvironmentStrings ();
    envc = 0;
    while (*psEnvStrings)
        {
        if (*psEnvStrings != '=')
            {
            envc++;
            }
        while (*psEnvStrings++);
        }
    psCmdLine = GetCommandLine ();
    pvBuffer = LocalAlloc (LMEM_FIXED, (argc     * sizeof (PSTR)) +
                                       ((envc+1) * sizeof (PSTR)) +
                                       (lstrlen (psCmdLine) + 1));
    if (pvBuffer != NULL)
        {
        argv = (PSTR *) pvBuffer;
        envp = (PSTR *) ((DWORD) argv + (argc     * sizeof (PSTR)));
        cmdp = (PSTR)   ((DWORD) envp + ((envc+1) * sizeof (PSTR)));
        lstrcpy (cmdp, psCmdLine);

        psCmdLine = cmdp;
        argc = 0;
        while (TRUE)
            {
            while (*psCmdLine++ == ' ');
            cQuote = (*--psCmdLine == '"' ? *psCmdLine++ : ' ');
            if (!*psCmdLine) break;
            argv [argc++] = psCmdLine;
            while (*psCmdLine)
                {
                if (*psCmdLine++ == cQuote)
                    {
                    *(psCmdLine-1) = 0;
                    break;
                    }
                }
            }
        psEnvStrings = GetEnvironmentStrings ();
        envc = 0;
        while (*psEnvStrings)
            {
            if (*psEnvStrings != '=')
                {
                envp [envc++] = psEnvStrings;
                }
            while (*psEnvStrings++);
            }
        envp [envc] = NULL;

        hStdIn  = GetStdHandle (STD_INPUT_HANDLE);
        hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
        hStdErr = GetStdHandle (STD_ERROR_HANDLE);

        if ((hStdIn  != INVALID_HANDLE_VALUE) &&
            (hStdOut != INVALID_HANDLE_VALUE) &&
            (hStdErr != INVALID_HANDLE_VALUE))
            {
            main (argc, argv, envp);
            }
        LocalFree (pvBuffer);
        }
    ExitProcess (0);
    }
    
// =================================================================
// STANDARD I/O
// =================================================================

int getchar (void)
    {
    int   c;
    DWORD n;

    c = 0;
    return (ReadFile (hStdIn, &c, 1, &n, NULL) && !--n ? c : EOF);
    }

// -----------------------------------------------------------------

int putchar (int c)
    {
    DWORD n;

    return (WriteFile (hStdOut, &c, 1, &n, NULL) && !--n ? c : EOF);
    }

// -----------------------------------------------------------------

int printf (PSTR psFormat, ...)
    {
    PSTR    psBuffer;
    PVOID   va_list;
    DWORD   l, n;

    n = (DWORD) -1;
    psBuffer = LocalAlloc (LMEM_FIXED, 8192);
    if (psBuffer != NULL)
        {
        va_list = (PVOID) ((DWORD) &psFormat + sizeof (PSTR));
        wvsprintf (psBuffer, psFormat, va_list);
        l = lstrlen (psBuffer);
        if (!(WriteFile (hStdOut, psBuffer, l, &n, NULL) && !(l-n)))
            {
            n = (DWORD) -1;
            }
        LocalFree (psBuffer);
        }
    return n;
    }
    
// -----------------------------------------------------------------

WORD KeyPressed (void)
    {
    INPUT_RECORD InputRecord;
    DWORD        dCount;
    WORD         wKeyCode = 0;

    GetNumberOfConsoleInputEvents (hStdIn, &dCount);
    while (dCount &&
           ReadConsoleInput (hStdIn, &InputRecord, 1, &dCount))
        {
        if ((InputRecord.EventType == KEY_EVENT) &&
            (InputRecord.Event.KeyEvent.bKeyDown))
            {
            wKeyCode = InputRecord.Event.KeyEvent.wVirtualKeyCode;
            break;
            }
        GetNumberOfConsoleInputEvents (hStdIn, &dCount);
        }
    return wKeyCode;
    }

// =================================================================
// END OF FILE
// =================================================================
