/*
    IsScrSv.cpp
    Written by Dan Shappir 1996.
*/
#ifndef STRICT
#define STRICT 1
#endif
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef WIN32_EXTRA_LEAN
#define WIN32_EXTRA_LEAN
#endif

#include <windows.h>
extern BOOL ScreenSaverActive(void);


const LPCTSTR szAppName = TEXT("IsScreenSaver");
const int     ID_TIMER  = 1;
const int     TIMER_RES = 1000;

HINSTANCE     hInstApp;
HWND          hWndApp;

LRESULT CALLBACK
WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch ( uMsg ) {
        case WM_CREATE:
            if ( SetTimer(hwnd, ID_TIMER, TIMER_RES, NULL) == 0 )
                return -1;
            break;

        case WM_DESTROY:
            KillTimer(hwnd, ID_TIMER);
            PostQuitMessage(0);
            return 0;

        case WM_TIMER:
            if ( ScreenSaverActive() )
                MessageBeep(MB_OK);
    }
    return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

#ifdef __BORLANDC__
#   pragma argsused
#endif
int WinInit(HINSTANCE hInstance, LPSTR lpCmdLine, int nCmdShow)
{
    WNDCLASS wndclass;
    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = WindowProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = HBRUSH(GetStockObject(WHITE_BRUSH));
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = szAppName;
    if ( !RegisterClass(&wndclass) )
        return -1;

    hInstApp = hInstance;
    hWndApp = CreateWindow(szAppName, szAppName,
                           WS_OVERLAPPEDWINDOW,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           NULL, NULL, hInstance, NULL) ;
    if ( hWndApp == NULL )
        return -1;

    ShowWindow(hWndApp, nCmdShow);
    return UpdateWindow(hWndApp);
}

int WINAPI
WinMain(HINSTANCE hInstance,HINSTANCE,LPSTR lpCmdLine,int nCmdShow)
{
    switch ( WinInit(hInstance, lpCmdLine, nCmdShow) ) {
        case -1:
            return 0;
        case 0:
            PostMessage(hWndApp, WM_CLOSE, 0, 0);
    }
    MSG msg;
    while ( GetMessage(&msg, NULL, 0, 0) )
        DispatchMessage(&msg);
    return msg.wParam;
}
// End Of File
