/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// wexpire.h : header file
//           
#ifndef _WEXPIRE_H
#define _WEXPIRE_H

#ifndef _NEWSSUP_H
#include "newssup.h"
#endif
#ifndef _UTILITY_H
#include "utility.h"
#endif

class CExpire : public CObject {
  public:
   CExpire( const char * Group , int Days , BOOL Flag = FALSE, const char * Archive = "");
   ~CExpire();
   const char * GetGroup() const { return m_Group; }
   int GetExpire() const { return m_Expire; }
   BOOL GetFlag() const { return m_Flag; }
   CString GetArchive() const { return m_Archive; }
  private:
	CString	m_Group;
   	int		m_Expire;
   	BOOL	m_Flag;
   	CString m_Archive;
};

class CExpireList {
  public:
	CExpireList( const char * FileName , int OverRide = -1 );
	~CExpireList();
	BOOL GetExpireTime( const char * Group , CTimeSpan &Time , CString& Archive);
	BOOL IsOk() const { return m_Ok; }	
  private:
	BOOL m_Ok;
	CString m_FileName;
	int m_OverRide;
	CObArray * m_ExpireList;
};   
	
    
/////////////////////////////////////////////////////////////////////////////
// the main expirer object
class CExpirer
{
// Construction
public:
	CExpirer();	// standard constructor
    virtual ~CExpirer();
	BOOL Init();
// Implementation
	BOOL ExpireMessage();	    
	BOOL ExpireNextGroup();
	
private: 
	// Functions
	BOOL DoError( const char * Str );
	// Data
	CExpireSetupInfo * m_Setup;
	CActiveList * m_ActiveList;	 
	CExpireList * m_ExpireList;
	CActive * m_CurrentGroup;                             
	CStdioFile * m_GroupFile;
	CStdioFile * m_IndexFile;
	CStdioFile * m_NewGroupFile;
	CStdioFile * m_NewIndexFile;
	CTime m_CurrentTime;
	CTimeSpan m_CurrentExpire;
	CTimeSpan m_DefaultExpireTime;
	CString m_CurrentArchive;
	POSITION m_CurrentPos;
	BOOL m_OkToWriteActive;
	CStatusDlg m_StatDlg;
	long m_CurrentNum;
};

#endif 
