/***********************************************************************
**
** CANIBMP.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
** It is the implementation of the CAnimatedBitmap class.
** This class responsible for animating itself in a particular
** location
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// mainfrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////
                                      
#ifndef _MAINDLG_H
#define _MAINDLG_H
#ifndef _NNTPDLG_H
#include "nntpdlg.h"
#endif
#ifndef _TIMEDLG_H                  
#include "timedlg.h"
#endif
#ifndef _SERVDLG_H                      
#include "servdlg.h"
#endif
#ifndef _SMTPDLG_H
#include "smtpdlg.h"
#endif

// Classes needed in this file
class CReindexer;
class CUnbatcher;
                                      
class CMainFrame : public CMDIFrameWnd
{
	DECLARE_DYNAMIC(CMainFrame)
public:
	CMainFrame();

// Attributes
public:

// Operations
public:

// Implementation
public:
	virtual ~CMainFrame();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	void DrawProgress();
	void DoBackground() { if ( m_Unbatcher != NULL ) _DoBackground(); }	
	void InitialShowWindow(UINT nCmdShow);
	virtual BOOL OnCommand( WPARAM wParam , LPARAM lParam );
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif


protected:	// control bar embedded members
	CStatusBar	m_wndStatusBar;
	CToolBar	m_wndToolBar;
	CNntpDlg	m_NntpDlg;
	CSmtpDlg	m_SmtpDlg;
	CServDlg	m_ServDlg;
// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnViewBar(UINT nID);
	afx_msg void OnUpdateBarMenu(CCmdUI* pCmdUI);
	afx_msg void OnClose();
	afx_msg void OnViewMailclient();
	afx_msg void OnViewNewsclient();
	afx_msg void OnViewPop3client();
	afx_msg void OnUpdateViewMailclient(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewNewsclient(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPop3client(CCmdUI* pCmdUI);
	afx_msg void OnKickAll();
	afx_msg void OnKickMail();
	afx_msg void OnKickNews();
	afx_msg void OnKickPop3();
	afx_msg void OnKickTime();
	afx_msg void OnUpdateKickAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateKickMail(CCmdUI* pCmdUI);
	afx_msg void OnUpdateKickNews(CCmdUI* pCmdUI);
	afx_msg void OnUpdateKickPop3(CCmdUI* pCmdUI);
	afx_msg void OnUpdateKickTime(CCmdUI* pCmdUI);
	afx_msg void OnFileDialup();
	afx_msg void OnUpdateFileDialup(CCmdUI* pCmdUI);
	afx_msg void OnFilePreferences();
	afx_msg void OnFileSetup();
	afx_msg void OnViewSmtpserver();
	afx_msg void OnUpdateViewSmtpserver(CCmdUI* pCmdUI);
	afx_msg void OnKickServ();
	afx_msg void OnUpdateKickServ(CCmdUI* pCmdUI);
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	afx_msg void OnServicesUnbatch();
	afx_msg void OnUpdateServicesUnbatch(CCmdUI* pCmdUI);
	afx_msg void OnSysColorChange();
	afx_msg void OnFingerDefault();
	afx_msg void OnUpdateFingerDefault(CCmdUI* pCmdUI);
	afx_msg void OnFingerOther();
	afx_msg void OnFileSaveWindow();
	afx_msg void OnServicesReindexnews();
	afx_msg void OnUpdateServicesReindexnews(CCmdUI* pCmdUI);
	afx_msg void OnServicesSortgrouplist();
	afx_msg void OnUpdateServicesSortgrouplist(CCmdUI* pCmdUI);
	afx_msg void OnFingerSetfont();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
  private:
  	void DoStartupKick();                                              
  	void _DoBackground();
  	
  	CReindexer * m_Reindexer;
  	CUnbatcher * m_Unbatcher;
};

/////////////////////////////////////////////////////////////////////////////
#endif
