/***********************************************************************
**
** initdlg.CPP
**
** Copyright 1994 by Ewan Kirk <ewan@kirk.demon.co.uk>
**
** Permission to use, copy, modify, distribute, and sell this software and its
** documentation for any purpose is hereby granted without fee, provided that
** the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of Ewan Kirk not be used in
** advertising or publicity pertaining to distribution of the software without
** specific, written prior permission.  Ewan Kirk makes no representations
** about the suitability of this software for any purpose.  It is provided
** "as is" without express or implied warranty.
**
** EWAN KIRK DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
** INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
** EVENT SHALL EWAN KIRK BE LIABLE FOR ANY SPECIAL, INDIRECT OR
** CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
** DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
** TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
** PERFORMANCE OF THIS SOFTWARE.
**
** This file is part of WINDIS. 
**
** V1.0 - Initial Revision 01-Sep-94
**
*/
// prefdlg.cpp : implementation file
//

#include "stdafx.h"
#include <direct.h> // for mkdir
#include "windis.h"         
#include "newssup.h"
#include "utility.h"
#include "initdlg.h"

// turn pcode on
#pragma optimize( "q" , on )

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInitialiseDlg dialog


CInitialiseDlg::CInitialiseDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInitialiseDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInitialiseDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CInitialiseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInitialiseDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CInitialiseDlg, CDialog)
	//{{AFX_MSG_MAP(CInitialiseDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CInitialiseDlg message handlers

void CInitialiseDlg::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
}

void CInitialiseDlg::OnCancel()
{
	// TODO: Add extra cleanup here MessageBox
	if( ::MsgBox( MB_OKCANCEL | MB_ICONSTOP, IDS_MSG_RUN_SETUP ) == IDCANCEL )
		  CDialog::OnCancel();
}

BOOL CInitialiseDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CenterWindow();	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
/////////////////////////////////////////////////////////////////////////////
// CInitSetupDlg dialog


CInitSetupDlg::CInitSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CInitSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInitSetupDlg)
	m_DemonFiles = "e.g. the directory c:\\demon";
	m_HostName = "e.g. yourhost.demon.co.uk";
	m_MailGate = "post.demon.co.uk";
	m_NewsServer = "news.demon.co.uk";
	m_TimeServer = "gate.demon.co.uk";
	m_TimeZone = "GMT0BST1";
	//}}AFX_DATA_INIT
}

void CInitSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInitSetupDlg)
	DDX_Text(pDX, IDC_INITDEMONFILES, m_DemonFiles);
	DDX_Text(pDX, IDC_INITHOSTNAME, m_HostName);
	DDX_Text(pDX, IDC_INITMAILGATE, m_MailGate);
	DDX_Text(pDX, IDC_INITNEWSSERVER, m_NewsServer);
	DDX_Text(pDX, IDC_INITTIMESERVER, m_TimeServer);
	DDX_Text(pDX, IDC_INITTIMEZONE, m_TimeZone);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CInitSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CInitSetupDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CInitSetupDlg message handlers

void CInitSetupDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}
                 
BOOL CInitSetupDlg::CheckFile( const char * FileName )
{   
	if( !FileExist( FileName ) )             
	{
		::MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_FILE_NOT_EXIST , FileName );
		return FALSE;
	}
	else
		return TRUE;
}
 
BOOL CInitSetupDlg::CheckDir( const char * DirName )
{                                               
	if( !DirExist( DirName ) )            
	{
		MsgBox( MB_OK | MB_ICONSTOP , IDS_MSG_DIR_NOT_EXIST , DirName );
		return FALSE;
	}
	else
		return TRUE;
}
	
void CInitSetupDlg::OnOK()
{
	// TODO: Add extra validation here
	UpdateData( TRUE );
	if( !CheckDir( m_DemonFiles ) )
		return;
	gConfig->SetKA9QRoot( m_DemonFiles );
	if( !CheckDir( GetNewsDirName()        )||
		!CheckFile(GetNewsActiveListName() )||
		!CheckFile(GetNewsGroupListName()  )||
		!CheckFile(GetNewsHistoryName()	   )||
		!CheckFile(GetSNewsHistoryName()   )||
		!CheckFile(GetNewsDataName()	   )||
		!CheckDir( GetNewsBaseDirName()    ))
		return;

	// Ok, got that.  What about the maildirs now.
	// Just check for the simple KA9Q stuff now.
	CString Tmp;
	Tmp = m_DemonFiles + "\\spool\\mqueue";
	if( !CheckDir( Tmp ) )
		return;
	gConfig->SetMailOutDir( Tmp );
	Tmp = m_DemonFiles + "\\spool\\mail";
	if( !CheckDir( Tmp ) )
		return;                   
	gConfig->SetMailInDir( Tmp );         
	
	gConfig->SetNewsServer( m_NewsServer );
	gConfig->SetMailGateway(m_MailGate );
	gConfig->SetTimeServer( m_TimeServer );
	gConfig->SetHostName( m_HostName );
	Tmp = m_DemonFiles + "\\log";
	if( !DirExist( Tmp ) )
	{
		if( mkdir( Tmp ) == -1 )
			MsgBox( MB_OK | MB_ICONSTOP , 
					IDS_MSG_LOG_DIRECTORY , (const char *)Tmp );
			
	}
	gConfig->SetLogPath( Tmp );                                   
	// Do the finger setup
	CStringArray FingerNames;
	gConfig->GetFingerNames( FingerNames );
	// Hostname is the bit of the string up to the first dot
	char * HostBuf = new char[ 256 ];
	strcpy( HostBuf , m_HostName );
	char * p = strtok( HostBuf , "." );
	CString Finger;
	if( p != NULL )
	{              
		Finger = p;
		Finger += "@";
		Finger += m_MailGate;
		FingerNames[ 0 ] = Finger;
		gConfig->SetFingerNames( FingerNames );
		gConfig->SetFingerDefault( Finger );
	};
	delete [] HostBuf;        
	gConfig->SetTimeZone( m_TimeZone );
	
	// Ok, that's it.  Everything is prettymuch set up.
	gConfig->SetVersion( WINDIS_VERSION );
	CDialog::OnOK();
	// Ok, get the data out of the boxes and do something with it.
	
}

BOOL CInitSetupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();               
	CenterWindow();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
