/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THSMSG.CPP

HStat Message/Method interface code

\***************************************************************************/

_WRAP_INLINE int _WRAPNAME(HStat)::GetAlign(void) 
	{
	return (int)_WRAP_SM(HSM_GETALIGN, 0, 0L);
	}
	
_WRAP_INLINE COLORREF _WRAPNAME(HStat)::GetBkgndColor(void) 
	{
	return (COLORREF)_WRAP_SM(HSM_GETBKGNDCOLOR, 0, 0L);
	}
	
_WRAP_INLINE COLORREF _WRAPNAME(HStat)::GetFrgndColor(void) 
	{
	return (COLORREF)_WRAP_SM(HSM_GETFRGNDCOLOR, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HStat)::GetText(LPSTR lpBuf, int iMaxLen) 
	{
	return (int)_WRAP_SM(HSM_GETTEXT, iMaxLen, (LONG)lpBuf);
	}            
	
_WRAP_INLINE int _WRAPNAME(HStat)::GetType(void) 
	{
	return (int)_WRAP_SM(HSM_GETTYPE, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HStat)::SetAlign(int iCode) 
	{
	_WRAP_SM(HSM_SETALIGN, iCode, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HStat)::SetBkgndColor(COLORREF cr, BOOL bRedraw) 
	{
	_WRAP_SM(HSM_SETBKGNDCOLOR, bRedraw, cr);
	}
	
_WRAP_INLINE void _WRAPNAME(HStat)::SetFrgndColor(COLORREF cr, BOOL bRedraw) 
	{
	_WRAP_SM(HSM_SETFRGNDCOLOR, bRedraw, cr);
	}
	   
#ifdef _OWLWRAP	   
	   
_WRAP_INLINE HANDLE _WRAPNAME(HStat)::GetPic(void) 
	{
	return (HANDLE)_WRAP_SM(HSM_GETIMAGE, 0, 0L);
	}
	
_WRAP_INLINE  HPALETTE _WRAPNAME(HStat)::GetPalette(void) 
  {
	return (HPALETTE)_WRAP_SM(HBM_GETPALETTE, 0, 0L);
  }  	
	
_WRAP_INLINE HANDLE _WRAPNAME(HStat)::SetPic(HANDLE hImage, WORD wType, BOOL bRedraw) 
	{
	return (HANDLE)_WRAP_SM(HSM_SETIMAGE, bRedraw, MAKELONG(hImage, wType));
	}                                                                         
	
#elif _AFX

_WRAP_INLINE CGdiObject *_WRAPNAME(HStat)::GetPic(void) 
	{
	return CGdiObject::FromHandle((HANDLE)_WRAP_SM(HSM_GETIMAGE, 0, 0L));
	}
	
_WRAP_INLINE  CPalette *_WRAPNAME(HStat)::GetPalette(void) 
  {
	return CPalette::FromHandle((HPALETTE)_WRAP_SM(HBM_GETPALETTE, 0, 0L));
  }  	
	
_WRAP_INLINE CGdiObject *_WRAPNAME(HStat)::SetPic(CGdiObject *pPic, WORD wType, BOOL bRedraw) 
	{
	return CGdiObject::FromHandle((HANDLE)_WRAP_SM(HSM_SETIMAGE, bRedraw, MAKELONG(pPic->GetSafeHandle(), wType)));
	}                                                                         


#endif	
	
_WRAP_INLINE void _WRAPNAME(HStat)::SetText(LPSTR lpszText) 
	{
	_WRAP_SM(HSM_SETTEXT, 0, (LONG)lpszText);
	}
	
_WRAP_INLINE void _WRAPNAME(HStat)::SetType(int iType, BOOL bRedraw) 
	{
	_WRAP_SM(HSM_SETTYPE, iType, bRedraw);
	}
	

