/***************************************************************************\
          (c) 1993, Simple Software, Inc., All rights reserved

	THCMSG.CPP

HComb Message/Method interface code

\***************************************************************************/

/*
HComb Method Wrappers
*/
    
     
_WRAP_INLINE int _WRAPNAME(HComb)::AddItem(LPVOID lpData) 
	{
	return (int)_WRAP_SM(HCM_ADDITEM, 0, DLP(lpData));
	}

_WRAP_INLINE int _WRAPNAME(HComb)::AddItemEx(LPVOID lpData, LPVOID lpCode) 
	{
	return HCAddItemEx(HWindow, lpData, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::AddItems(int iCount, LPVOID lpData) 
	{
	return HCAddItems(HWindow, iCount, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::AddItemsEx(int iCount, LPVOID lpData, LPVOID lpCode) 
	{
	return HCAddItemsEx(HWindow, iCount, lpData, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::DeleteItem(int iIndex) 
	{
	return (int)_WRAP_SM(HCM_DELETEITEM, iIndex, 0L);
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::DeleteItems(WORD wSearch, int iCount, LPVOID lpInfo) 
	{
	return HCDeleteItems(HWindow, wSearch, iCount, lpInfo);
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::EmptyList(void) 
	{
	return (BOOL)_WRAP_SM(HCM_RESETCONTENT, 0, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::FindCode(int iStart, LPVOID lpCode) 
	{
	return (int)_WRAP_SM(HCM_FINDCODE, iStart, DLP(lpCode));
	}

_WRAP_INLINE int _WRAPNAME(HComb)::FindData(int iStart, LPVOID lpData) 
	{
	return (int)_WRAP_SM(HCM_FINDDATA, iStart, DLP(lpData));
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::FindString(int iStart, LPSTR lpString) 
	{
	return (int)_WRAP_SM(HCM_FINDSTRING, iStart, (LONG)(LPSTR)lpString);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HComb)::GetCode(int iIndex, LPVOID lpCode) 
	{
	return (BOOL)_WRAP_SM(HCM_GETCODE, iIndex, DLP(lpCode));
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::GetData(int iIndex, LPVOID lpData) 
	{
	return (BOOL)_WRAP_SM(HCM_GETDATA, iIndex, DLP(lpData));
	}

_WRAP_INLINE int _WRAPNAME(HComb)::GetItems(int iCount, WORD wReturn, LPVOID lpReturn, WORD wSearch, LPVOID lpInfo) 
	{
	return HCGetItems(HWindow, iCount, wReturn, lpReturn, wSearch, lpInfo);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::InsertItem(int iPos, LPVOID lpData) 
	{
	return (int) _WRAP_SM(HCM_INSERTITEM, iPos, DLP(lpData));
	}     

_WRAP_INLINE int _WRAPNAME(HComb)::InsertItemEx(int iPos, LPVOID lpData, LPVOID lpCode) 
	{
	return HCInsertItemEx(HWindow, iPos, lpData, lpCode);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::InsertItems(int iPos, int iCount, LPVOID lpData) 
	{
	return HCInsertItems(HWindow, iPos, iCount, lpData);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::InsertItemsEx(int iPos, int iCount, LPVOID lpData, LPVOID lpCode) 
	{
	return HCInsertItemsEx(HWindow, iPos, iCount, lpData, lpCode);
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::IsSelected(int iIndex) 
	{
	return (BOOL)(_WRAP_SM(HCM_GETCURSEL, 0, 0L) == iIndex);
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::SelectCode(LPVOID lpCode) 
	{
	return (BOOL)_WRAP_SM(HCM_SELECTCODE, TRUE, DLP(lpCode));
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::SelectData(LPVOID lpData) 
	{
	return (BOOL)_WRAP_SM(HCM_SELECTDATA, TRUE, DLP(lpData));
	}

_WRAP_INLINE int _WRAPNAME(HComb)::SelectString(int iStart, LPSTR lpString) 
	{
	return (int)_WRAP_SM(HCM_SELECTSTRING, iStart, (LONG)(LPSTR)lpString);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HComb)::SetCode(int iIndex, LPVOID lpCode) 
	{
	return (BOOL)_WRAP_SM(HCM_SETCODE, iIndex, DLP(lpCode));
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::SetCodeLink(LPVOID lpCode, BOOL bSelect) 
	{
	return (BOOL)_WRAP_SM(HCM_SETCODELINK, bSelect, DLP(lpCode));
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::SetDataLink(LPVOID lpData, BOOL bSelect) 
	{
	return (BOOL)_WRAP_SM(HCM_SETDATALINK, bSelect, DLP(lpData));
	}



/*
HCist Message Wrappers
*/

_WRAP_INLINE BOOL _WRAPNAME(HComb)::HasChanged(void) 
	{
	return (BOOL)_WRAP_SM(HCM_HASCHANGED, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HComb)::GetFormat(LPSTR lpFormat, int iMaxLen) 
	{
	_WRAP_SM(HCM_GETFORMAT, iMaxLen, (LONG)lpFormat);
	}

_WRAP_INLINE BOOL _WRAPNAME(HComb)::SetChanged(BOOL bChanged) 
	{
	return (BOOL)_WRAP_SM(HCM_SETCHANGED, (WORD)bChanged, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::SetFormat(LPSTR lpFormat, BOOL bRedraw) 
	{
	return (int)_WRAP_SM(HCM_SETFORMAT, bRedraw, (LONG)lpFormat);
	} 
	
#ifdef _OWLWRAP	
	
_WRAP_INLINE HBRUSH _WRAPNAME(HComb)::GetBkgndBrush(void) 
	{
	return (HBRUSH)_WRAP_SM(HCM_GETBKGNDBRUSH, 0, 0L);
	}
	
_WRAP_INLINE HFONT _WRAPNAME(HComb)::GetFont(void) 
	{
	return (HFONT)_WRAP_SM(HCM_GETFONT, 0, 0L);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HComb)::GetHiliteBrush(void) 
	{
	return (HBRUSH)_WRAP_SM(HCM_GETHILITEBRUSH, 0, 0L);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HComb)::SetHilteBrush(HBRUSH hBrush, BOOL bRedraw) 
	{
	return (HBRUSH)_WRAP_SM(HCM_SETHILITEBRUSH, (WORD)hBrush, (LONG)bRedraw);
	}
	
_WRAP_INLINE HBRUSH _WRAPNAME(HComb)::SetBkgndBrush(HBRUSH hBkgnd, BOOL bRedraw) 
	{
	return (HBRUSH)_WRAP_SM(HCM_SETBKGNDBRUSH, (WORD)hBkgnd, (LONG)bRedraw);
	}
	
_WRAP_INLINE HFONT _WRAPNAME(HComb)::SetFont(HFONT hFont, BOOL bRedraw) 
	{
	return (HFONT)_WRAP_SM(HCM_SETFONT, (WORD)hFont, bRedraw);
	}  
	
#elif _AFX   

_WRAP_INLINE CBrush *_WRAPNAME(HComb)::GetBkgndBrush(void) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HCM_GETBKGNDBRUSH, 0, 0L));
	}
	
_WRAP_INLINE CFont *_WRAPNAME(HComb)::GetFont(void) 
	{
	return CFont::FromHandle((HFONT)_WRAP_SM(HCM_GETFONT, 0, 0L));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HComb)::GetHiliteBrush(void) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HCM_GETHILITEBRUSH, 0, 0L));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HComb)::SetHiliteBrush(CBrush *pBrush, BOOL bRedraw) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HCM_SETHILITEBRUSH, (WPARAM)pBrush->GetSafeHandle(), (LONG)bRedraw));
	}
	
_WRAP_INLINE CBrush *_WRAPNAME(HComb)::SetBkgndBrush(CBrush *pBkgnd, BOOL bRedraw) 
	{
	return CBrush::FromHandle((HBRUSH)_WRAP_SM(HCM_SETBKGNDBRUSH, (WPARAM)pBkgnd->GetSafeHandle(), (LONG)bRedraw));
	}
	
_WRAP_INLINE CFont *_WRAPNAME(HComb)::SetFont(CFont *pFont, BOOL bRedraw) 
	{
	return CFont::FromHandle((HFONT)_WRAP_SM(HCM_SETFONT, (WPARAM)pFont->GetSafeHandle(), bRedraw));
	}  

#endif
	
_WRAP_INLINE int _WRAPNAME(HComb)::SetTabStops(int iNum, LPINT lpTStops) 
	{
	return (int)_WRAP_SM(HCM_SETTABSTOPS, iNum, (LONG)lpTStops);
	} 
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetDropHeight() 
	{
	return (int)_WRAP_SM(HCM_GETDROPHEIGHT, 0, 0L);
	} 	   
	
_WRAP_INLINE BOOL _WRAPNAME(HComb)::SetDropHeight(int iNewHeight) 
	{
	return (BOOL)_WRAP_SM(HCM_SETDROPHEIGHT, (WPARAM)iNewHeight, 0L);
	} 	
	
_WRAP_INLINE void _WRAPNAME(HComb)::SetTextColor(COLORREF crNew, BOOL bNeg) 
	{
	_WRAP_SM(HCM_SETTEXTCOLOR, (WPARAM)bNeg, crNew);
	}	  	
	
_WRAP_INLINE COLORREF _WRAPNAME(HComb)::GetTextColor(BOOL bNeg) 
	{
	return (COLORREF)_WRAP_SM(HCM_GETTEXTCOLOR, (WPARAM)bNeg, 0L);
	}	                                                        

_WRAP_INLINE int _WRAPNAME(HComb)::GetEditData(LPVOID lpData, int iMaxLen) 
	{
	return (int)_WRAP_SM(HCM_GETEDITDATA, iMaxLen, (LONG)lpData);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::SetEditData(LPVOID lpData) 
	{
	return (int)_WRAP_SM(HCM_SETEDITDATA, 0, (LONG)lpData);
	}
	
_WRAP_INLINE LONG _WRAPNAME(HComb)::GetEditSel(void) 
	{
	return (LONG)_WRAP_SM(HCM_GETEDITSEL, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HComb)::SetEditSel(int iAnchor, int iExtent) 
	{
	_WRAP_SM(HCM_SETEDITSEL, 0, MAKELONG(iAnchor, iExtent));
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetEditText(LPSTR lpText, int iMaxLen) 
	{
	return (int)_WRAP_SM(HCM_GETEDITTEXT, iMaxLen, (LONG)lpText);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetEditTextLen(void) 
	{
	return (int)_WRAP_SM(HCM_GETEDITTEXTLEN, 0, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HComb)::SetMaxTextLen(int iLen) 
	{
	_WRAP_SM(HEM_SETMAXTEXTLEN, iLen, 0L);
	}
	
_WRAP_INLINE void _WRAPNAME(HComb)::SetOverwrite(BOOL bOverwrite) 
	{
	_WRAP_SM(HCM_SETOVERWRITEMODE, bOverwrite, 0L);
	}     
	
_WRAP_INLINE void _WRAPNAME(HComb)::Update(BOOL bUpdateData)
	{
	_WRAP_SM(HCM_UPDATE, bUpdateData, 0L);
	}     
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetEditScrollPos(void)
	{
	return (int)_WRAP_SM(HCM_GETEDITSCROLLPOS, 0, 0L);
	}	     
	
_WRAP_INLINE int _WRAPNAME(HComb)::SetEditScrollPos(int iScroll, BOOL bRedraw) 
	{
	return (int)_WRAP_SM(HCM_SETEDITSCROLLPOS, (WPARAM)iScroll, (LPARAM)bRedraw);
	}	  	                         
	


_WRAP_INLINE char _WRAPNAME(HComb)::GetCodeClass(void) 
	{
	return (char)_WRAP_SM(HCM_GETCODECLASS, 0, 0L);
	}
	
_WRAP_INLINE LPVOID _WRAPNAME(HComb)::GetCodeLink(void) 
	{
	return (LPVOID)_WRAP_SM(HCM_GETCODELINK, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetCodeSize(int iIndex) 
	{
	return (int)_WRAP_SM(HCM_GETCODESIZE, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetCodeType(void) 
	{
	return (int)_WRAP_SM(HCM_GETCODETYPE, 0, 0L);
	}                       
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetCount(void) 
	{
	return (int)_WRAP_SM(HCM_GETCOUNT, 0, 0L);
	}
		
_WRAP_INLINE BOOL _WRAPNAME(HComb)::GetCurCode(LPVOID lpBuf) 
	{
	return (BOOL)_WRAP_SM(HCM_GETCURCODE, 0, (LONG)lpBuf);
	}
	
_WRAP_INLINE BOOL _WRAPNAME(HComb)::GetCurData(LPVOID lpBuf) 
	{
	return (BOOL)_WRAP_SM(HCM_GETCURDATA, 0, (LONG)lpBuf);
	}
	
_WRAP_INLINE char _WRAPNAME(HComb)::GetDataClass(void) 
	{
	return (char)_WRAP_SM(HCM_GETDATACLASS, 0, 0L);
	}
	
_WRAP_INLINE LPVOID _WRAPNAME(HComb)::GetDataLink(void) 
	{
	return (LPVOID)_WRAP_SM(HCM_GETDATALINK, 0, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetDataSize(int iIndex) 
	{
	return (int)_WRAP_SM(HCM_GETDATASIZE, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetDataType(void) 
	{
	return (int)_WRAP_SM(HCM_GETDATATYPE, 0, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::GetText(LPSTR lpBuf, int iIndex) 
	{
	return (int)_WRAP_SM(HCM_GETTEXT, iIndex, (LONG)lpBuf);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::GetTextLen(int iIndex) 
	{
	return (int)_WRAP_SM(HCM_GETTEXTLEN, iIndex, 0L);
	}
	
_WRAP_INLINE int _WRAPNAME(HComb)::SetCurSel(int iIndex) 
	{
	return (int)_WRAP_SM(HCM_SETCURSEL, iIndex, 0L);
	}

_WRAP_INLINE int _WRAPNAME(HComb)::GetCurSel(void) 
	{
	return (int)_WRAP_SM(HCM_GETCURSEL, 0, 0L);
  }
	

_WRAP_INLINE void _WRAPNAME(HComb)::SetScrollPos(int iPos)  
	{
	_WRAP_SM(HCM_SETSCROLLPOS, iPos, 0L);
	}

