;***************************************************************
;* WinCis Commands Commands                                    *
;***************************************************************
;
; REMOVE or SET ACTION flags for forum as tasks are completed
; 
; REMOVEACTION &&FORUMNAME Join.Forum
; SETACTION    &&FORUMNAME Set.Defaults
;
; Valid action flags
; Join.Forum
; Set.Defaults
; Update.Sections
; Read.Announcements
; Scan.New.Messages
; Read.Messages
; Send.Replies
; Read.New.Messages
; Read.Waiting.Messages
; Scan.Libraries
; Download.Files
; Upload.FIles
;
;
;
;  GO           forum_name
;  RESET
;  KILLFILE     filename
;  KILLDIR      directory
;  MAKEDIR      directory
;  LIB          library_number
;
;  SCANMES
;  SCANTHR
;  SCANLIB
;  QSCNLIB
;
;  JOIN
;
;  DOWNLOAD     filename pathname
;
;  READSEC
;  READMES
;  READTHR
;  READANN
;  READMAIL
;
;  RECORD
;
;  DO           scriptfile
;
;  LOGOFF
;  OFF
;  QUIT
;
;  S
;  SE
;  SEND         text
;
;  U
;  W
;  WA
;  WAIT         text
;
;  P
;  PA
;  PAUSE        number_of_seconds
;
;  C
;  CA
;  CAPTURE      filename
;
;  PR
;  PRINT        ON, or OFF
;
;  LOG          text
;
;  EC
;  ECHO         text
;               ON, or OFF
;
;  EN
;  END
;
;  N
;  NA
;  NAME
;
;  US
;  USER
;  USERID
;  RET
;  RETURN
;
;  DEBUG        ON, or OFF
;***************************************************************
;* WinCis Variables                                            *
;***************************************************************
;       WinCis Variables are denoted by a single & characters &
;       these variables are replaced with string values at the
;       time WinCis executes the script.
;
; "&USERID"             CompuServe      UserID
; "&NAME"                               UserName
; "&PASSWORD"                           User Password
; "&GATEWAY"            Current Gateway
; "&FORUM"              Current Forum
;
;***************************************************************
;* WinCis Conditional Commands                                 *
;***************************************************************
;
;
;     '%', '?' or '@'   are prefix condition characters that can
;                       prefix any command in order to make the
;                       command conditional on the success of any
;                       prior command.
;
;       Each occurrence of these prefix conditions denotes a
;       level of nesting that should be considered prior to
;       executing the command. Up to 10 levels of nesting
;       (or 10 prefix conditions) can be checked.
;
;       Basically processing proceeds as follows:
:
;       For each Prefix condition:
;
;       For I = 0 to the Number-of-Prefix-Conditions
;               If The_Condition_At(I) = FALSE Then Skip This Command
;       Next
;
;       All Conditions are true So Perform the command and save the return code...
;
;       ReturnCode = Command()
;
;       If the command worked then ReturnCode = TRUE Else ReturnCode  = FALSE
;
;       Now set the next higher condition to the value of the ReturnCode so that
;       Other commands can be based on the success of the command just executed
;
;       Set The_Condition_At(Number-Of-Prefix-Conditions + 1) = ReturnCode
;
;
;       The Prefix Conditions Denote the following conditions
;
;
;      %   Defines a TRUE  condition at this error level
;      @   Defines a FALSE condition at this error level
;      ?   Defines a Don't Care Condition at this  error level
;
;
;       The following is an example of some of the concepts presented:
;
;
;       GO FORUM
;       ; This command will always be executed since there are no
;       ; prefix conditions.  If WinCis successfully enters the FORUM
;       ; then the condition at level 1 will be set to TRUE otherwise it
;       ; will be set to FALSE
;
;       %ECHO We entered the FORUM successfully
;       ; The ECHO command will execute only if the condition at level 1 is TRUE
;       ; The ECHO Command does not return a condition and therefore does not
;       ; affect the condition at level 2
;
;       %LIB 1
;       ; We will only go to library 1 if the condition at level 1 is TRUE
;       ; this of course depends on that success of the GO FORUM Command
;       ; If the command is executed it will set the condition at Level 2
;
;       %%SCANLIB KEY:PROGRAMS LIB:ALL
;       ; Scanning for programs will depend of the success of getting to the Library Prompt
;       ; Therefore this command depends of the success of both the GO FORUM and LIB 1
;       ; commands.  Here we test 2 levels of prefix conditions denoted by the fact that
;       ; there are 2 '%' characters prefixing the SCANLIB Command
;       ; If the command is executed it will set the condition at Level 3
;
;       %@ECHO Can't Enter library 1 of the FORUM
;       ; This command will only be executed if we successfully entered the forum
;       ; and were unable to enter the library.  Since the first prefix_condition is
;       ; an % the condition at level 1 must be true, this was set by the value returned
;       ; by the GO FORUM command. If GO FORUM was not successful the command would be skipped
;       ; The second prefix_condition @ indicates that the condition at level 2 must be FALSE
;       ; this condition was last established by the %LIB 1 command.
;       ; The ECHO Command does not return a condition and therefore does not
;       ; affect the condition at level 3
;
;       @ECHO Can't Enter the FORUM
;       ; This command will only be executed if the GO FORUM command was unsuccessful
;       ; the @ indicates that the condition at level 1 must be FALSE.  This of course
;       ; was last set by the GO FORUM command.
;
;
;***************************************************************
;* Template Variables                                          *
;***************************************************************
;
;       Template Variables are denoted by the characters &&
;       these variables are replaced with string values at the
;       time WinCis generates the script.  Don't confuse template
;       variables with script variables.  Script variables are
;       evaluated when the script is executed by WinCis
;
;
;
; "&&USERID"        CompuServe UserID
; "&&USERNAME"                 UserName
; "&&PHONENUMBER"              PhoneNumber
; "&&LOGONSCRIPT"              LogonScript
;
; "&&GATEWAY"         Forum    Gateway
; "&&FORUMNAME"                Name
; "&&FORUMTITLE",              Title
; "&&CONTROLPATH"     Path For Control Files
; "&&DOWNLOADPATH"             Downloads
; "&&MESSAGEPATH"              Messages
; "&&SCRIPTPATH"               Scripts
;
; "&&LIBRARY"         Library  Number
; "&&DOWNLOADFILE"    Download FileName
; "&&DOWNLOADSIZE"             Filesize
; "&&DOWNLOADDATE"             Filedate
; "&&DOWNLOADCOUNT"            #DownLoads
; "&&DOWNLOADUPLD"             Uploaded by this CIS User
; "&&DOWNLOADTITLE"            Title Description of File
;
; "&&SCANFILE"        LibraryScan FileName
; "&&SCANAGE"                     Days old or age
; "&&SCANLIBS"                    Libraries to scan through
; "&&SCANKEYWORDS"                Keywords to look for
; "&&SCANTYPE"                    Short or long descriptions
; "&&SCANDESC"                    Description of this scan
;
; "&&READMSGSECTION"  ReadMessage Section Number
; "&&READMSGNUMBNER"              Thread or Message Number
;
; "&&VERSION"         WinCis Version Number
; "&&DATE"            Date script was created
; "&&TIME"            Time script was created
;
;
;
;
[PROLOG]
;
; This script file was created on &&DATE at &&TIME by &&USERNAME.
;
;***********************************************************************
;       WinCIS &&VERSION
;       Copyright(C) 1992
;       Larry Lee (76670,1471)
;       16038 Augusta Drive
;       Chino Hills, Ca 91709
;***********************************************************************
;
;
XMITFILTER C:\VB2\German.Map
WAIT !
SEND SET BRIEF YES^M
WAIT !
SEND SET PAGED NO^M
WAIT !
SEND SET BLANK YES^M
WAIT !
SEND SET WIDTH 80^M
WAIT !
;
[EPILOG]
;
;***********************************************************************
; All Done, Just Log off CompuServe
;***********************************************************************
;
LOGOFF

[READ MAIL]
;
; Read Any Waiting CompuServe Mail
;
 IF MAILWAITING
  @REMOVEACTION MAIL Read.Waiting
  %ECHO Reading CompuServe Mail
  %READMAIL &&SYSMESSAGEPATHMAIL.MSG
    %%ECHO CompuServe Mail Read Complete!
    %%REMOVEACTION MAIL Read.Waiting
    %@ECHO Unable to Read your CompuServe Mail!


[SEND MAIL]
;
; Send Any Waiting CompuServe Mail
;
  IF FILEEXISTS &&SYSMESSAGEPATHMAIL.SND
  @REMOVEACTION MAIL Send.Replies
  %ECHO Sending CompuServe Mail
  %SENDMAIL  &&SYSMESSAGEPATHMAIL.SND
    %@ECHO Unable to Send your CompuServe Mail!
    %%ECHO CompuServe Mail Send Complete!
    %%REMOVEACTION MAIL Send.Replies

[PROMPT MAIL OUTBOX]
;
; Ask what about Overwriting to the Mail OutBox
;
     %%ASK OVERWRITE? &&SYSMESSAGEPATHMAIL.MOX  Do you want to save your outgoing Mail in &&SYSMESSAGEPATHMAIL.MOX
     %%%ECHO Saving Your Out Going Mail to &&SYSMESSAGEPATHMAIL.MOX
     %%%FILEMARK &&SYSMESSAGEPATHMAIL.MOX MAIL_SENT CIS:MAIL
     %%%COPYFILE &&SYSMESSAGEPATHMAIL.SND &&SYSMESSAGEPATHMAIL.MOX
; At This point the Mail File Is No Longer Needed
     %%KILLFILE &&SYSMESSAGEPATHMAIL.SND


[APPEND MAIL OUTBOX]
;
; Append Queued Mail to the Mail OutBox
;
   %%ECHO Appending your outgoing Mail to &&SYSMESSAGEPATHMAIL.MOX
   %%FILEMARK &&SYSMESSAGEPATHMAIL.MOX MAIL_SENT &&FORUMNAME
   %%COPYFILE &&SYSMESSAGEPATHMAIL.SND &&SYSMESSAGEPATHMAIL.MOX
; At This point the Mail File Is No Longer Needed
   %%%KILLFILE &&SYSMESSAGEPATHMAIL.SND

[OVERWRITE MAIL OUTBOX]
;
; Overwrite Queued Mail to the &&FORUMNAME OutBox
;
   %%ECHO Saving your outgoing Mail in &&SYSPATH&&FORUMNAME.MOX
   %%KILLFILE &&SYSMESSAGEPATHMAIL.MOX
   %%FILEMARK &&SYSMESSAGEPATHMAIL.MOX MAIL_SENT &&FORUMNAME
   %%COPYFILE &&SYSMESSAGEPATHMAIL.SND &&SYSMESSAGEPATHMAIL.MOX
; At This point the Message File Is No Longer Needed
   %%%KILLFILE &&SYSMESSAGEPATHMAIL.SND

[DELETE MAIL OUTBOX]
;
; Never Save Queued Mail to the Mail OutBox
;
   %%ECHO Deleting outgoing Mail: &&SYSMESSAGEPATHMAIL.SND
; At This point the Mail File Is No Longer Needed
   %%KILLFILE &&SYSMESSAGEPATHMAIL.SND

[GO FORUM]
;
;***********************************************************************
; Lets enter the &&FORUMNAME forum, &&FORUMTITLE
;***********************************************************************
ECHO Going to &&FORUMNAME, &&FORUMTITLE
GO &&GATEWAY:&&FORUMNAME
;
; Join Forum If Required!
;
  %IF NOT JOINED
    %@REMOVEACTION &&FORUMNAME Join.Forum 	
    %%ECHO Attempting to Join &&FORUMNAME, &&FORUMTITLE
    %%JOIN
        %%%ECHO Successfully Joined &&FORUMNAME, &&FORUMTITLE
  	%%%REMOVEACTION &&FORUMNAME Join.Forum 	
        %%WAIT !
        %%@ECHO Sorry, unable to Join &&FORUMNAME, &&FORUMTITLE
        %%@SETERRORLEVEL 0 FALSE
;
; Set Session Defaults to Command Mode for Forum Processing
;
  %ECHO Setting Temporary Session Defaults in &&FORUMNAME, &&FORUMTITLE
  %SEND OPT;INI;1;MOD;3;EDI EDIT;PAU N;REP LIST;TYPE N;SKIP N;CHAR;S^M
  %WAIT New prompt:
  %%SEND ^^G^M
  %WAIT FORUM !
    %@SETERRORLEVEL 0 FALSE
;
  @ECHO Sorry, unable to enter the &&FORUMNAME Forum!
  %ECHO Now in &&FORUMNAME, &&FORUMTITLE
;
; Check for Waiting Messages in the &&FORUMNAME Forum
;
  %IF MESSAGESWAITING
    %@ECHO No Messages Waiting to be Read On &&FORUMNAME, &&FORUMTITLE
    %@REMOVEACTION &&FORUMNAME Read.Waiting.Messages
    %%ECHO Reading Waiting Messages of &&FORUMNAME, &&FORUMTITLE
    %%SCAN &&MESSAGEPATH&&FORUMNAME.MSG READ WAIT
    %%REMOVEACTION &&FORUMNAME Read.Waiting.Messages
;

[GO LIB]
;
; Lets enter Library #&&LIBRARY of &&FORUMNAME
  %LIB &&LIBRARY
;
; If something goes wrong... Inform the user and bypass this Library!
;   Otherwise all is well... Continue processing (downloads, catalogs, etc)
;
    %@ECHO Sorry, unable to enter Library #&&LIBRARY of &&FORUMNAME, &&FORUMTITLE
    %%ECHO Now In &&FORUMNAME, &&FORUMTITLE Libraries
;

[JOIN FORUM]
;
; Commented Out Since It's Done at GO FORUM Automatically
; Join The Forum
;
;  %IF NOT JOINED
;    %@REMOVEACTION &&FORUMNAME Join.Forum
;    %%ECHO Attempting to Join &&FORUMNAME, &&FORUMTITLE
;    %%JOIN
;       %%%ECHO Successfully Joined &&FORUMNAME, &&FORUMTITLE
;       %%%REMOVEACTION &&FORUMNAME Join.Forum
;       %%@ECHO Sorry, unable to Join &&FORUMNAME Forum!

[SET FORUM DEFAULTS]
;
; Set Permanent Session Defaults to Command Mode for Forum Processing
;
  %ECHO Setting Permanent Session Defaults in &&FORUMNAME, &&FORUMTITLE
  %SEND OPT;INI;1;MOD;3;EDI EDIT;PAU N;REP LIST;TYPE N;SKIP N;P^M
  %WAIT FORUM !
  %REMOVEACTION &&FORUMNAME Set.Defaults
 

[UPDATE FORUM SECTIONS]
;
; Read the Section Descriptions
;
  %ECHO Updating &&FORUMNAME, &&FORUMTITLE Message And Library Descriptions
  %KILLFILE &&CONTROLPATH&&FORUMNAME.SEC
  %READ &&CONTROLPATH&&FORUMNAME.SEC NAM;1;2;M
  %REMOVEACTION &&FORUMNAME Update.Sections

[READ FORUM ANNOUNCEMENTS]
;
; Read the &&FORUMNAME Forum Announcements
;
  %ECHO Reading &&FORUMNAME, &&FORUMTITLE Announcements
  %READANN &&MESSAGEPATH&&FORUMNAME.MSG
  %REMOVEACTION &&FORUMNAME Read.Announcements

[GO MESSAGES]
;
; Enter Message Area of the &&FORUMNAME Forum
;
  %MESSAGES
;
; If something goes wrong... Inform the user and bypass the Message Area!
;   Otherwise all is well... Continue processing (READS, SCANS, ...)
;
   %@ECHO Sorry, unable to enter Message Area of &&FORUMNAME, &&FORUMTITLE
   %%ECHO Now In &&FORUMNAME, &&FORUMTITLE Message Area
;

[READ FORUM MESSAGES]
    %%READ &&MESSAGEPATH&&FORUMNAME.MSG READ THR NUM:&&READMSGNUMBER

[RESET READ FORUM MESSAGES]
;
;  At this point no messages need to be read so Kill Then Read Msg Index
    %%REMOVEACTION &&FORUMNAME Read.Messages
    %%KILLFILE &&CONTROLPATH&&FORUMNAME.MXS

[READ WAITING FORUM MESSAGES]
;
; Commented Out Since It's Done at GO FORUM Automatically
; Check for Waiting Messages in the &&FORUMNAME Forum
;
;  %%IF MESSAGESWAITING
;    %%@REMOVEACTION &&FORUMNAME Read.Waiting.Messages
;    %%@ECHO No Messages Waiting to be Read On &&FORUMNAME, &&FORUMTITLE
;    %%%ECHO Reading Waiting Messages of &&FORUMNAME, &&FORUMTITLE
;    %%%SCAN &&MESSAGEPATH&&FORUMNAME.MSG READ WAIT
;    %%%REMOVEACTION &&FORUMNAME Read.Waiting.Messages

[READ NEW FORUM MESSAGES]
;
; Read New Messages in the &&FORUMNAME Forum
;
    %%ECHO Reading New Messages of &&FORUMNAME, &&FORUMTITLE in Sections &&MSGSECTIONS
    %%SCAN &&MESSAGEPATH&&FORUMNAME.MSG READ NEW &&MSGSECTIONS
    %%REMOVEACTION &&FORUMNAME Read.New.Messages

[QUICKSCAN FORUM MESSAGE HEADERS]
;
; Scan For New Messages Threads in the &&FORUMNAME Forum and Overwrite existing File
;
    %%ECHO Scanning For New Threads of &&FORUMNAME, &&FORUMTITLE in Sections &&MSGSECTIONS
    %%KILLFILE &&CONTROLPATH&&FORUMNAME.MQS
    %%SCAN &&CONTROLPATH&&FORUMNAME.MQS SCAN QUICK NEW &&MSGSECTIONS;T
    %%REMOVEACTION &&FORUMNAME Scan.New.Messages

[SEND FORUM MESSAGE]
;
; Sending Queued Messages and Replies to the &&FORUMNAME Forum
;
    %%ECHO Sending Queued Messages and Replies to &&FORUMNAME, &&FORUMTITLE
    %%SENDMSGS &&MESSAGEPATH&&FORUMNAME.SND

[PROMPT MESSAGE OUTBOX]
;
; Ask what to do about copying the OutGoing Messages
;
   %%%ASK OVERWRITE? &&CONTROLPATH&&FORUMNAME.MOX  Do you want to save your outgoing &&FORUMNAME Messages in &&MESSAGEPATH&&FORUMNAME.MOX?
   %%%%ECHO Saving your outgoing Messages to &&MESSAGEPATH&&FORUMNAME.MOX
   %%%%FILEMARK  &&MESSAGEPATH&&FORUMNAME.MOX MESSAGES_SENT &&FORUMNAME
   %%%%COPYFILE  &&MESSAGEPATH&&FORUMNAME.SND &&MESSAGEPATH&&FORUMNAME.MOX
; At This point the Message File Is No Longer Needed
   %%%REMOVEACTION &&FORUMNAME Send.Replies
   %%%KILLFILE &&MESSAGEPATH&&FORUMNAME.SND


[APPEND MESSAGE OUTBOX]
;
; Append Queued Messages and Replies to the &&FORUMNAME Forum OutBox
;
   %%%ECHO Appending your outgoing &&FORUMNAME Messages to &&MESSAGEPATH&&FORUMNAME.MOX
   %%%FILEMARK &&MESSAGEPATH&&FORUMNAME.MOX MESSAGES_SENT &&FORUMNAME
   %%%COPYFILE &&MESSAGEPATH&&FORUMNAME.SND &&MESSAGEPATH&&FORUMNAME.MOX
; At This point the Message File Is No Longer Needed
   %%%%REMOVEACTION &&FORUMNAME Send.Replies
   %%%%KILLFILE &&MESSAGEPATH&&FORUMNAME.SND
;
[OVERWRITE MESSAGE OUTBOX]
;
; Overwrite Queued Messages and Replies to the &&FORUMNAME Forum OutBox
;
   %%%ECHO Saving your outgoing &&FORUMNAME Messages in &&MESSAGEPATH&&FORUMNAME.MOX
   %%%%KILLFILE &&MESSAGEPATH&&FORUMNAME.MOX
   %%%FILEMARK  &&MESSAGEPATH&&FORUMNAME.MOX MESSAGES_SENT &&FORUMNAME
   %%%COPYFILE  &&MESSAGEPATH&&FORUMNAME.SND &&MESSAGEPATH&&FORUMNAME.MOX
; At This point the Message File Is No Longer Needed
   %%%%REMOVEACTION &&FORUMNAME Send.Replies
   %%%%KILLFILE &&MESSAGEPATH&&FORUMNAME.SND

[DELETE MESSAGE OUTBOX]
;
; Never Save Queued Messages to the &&FORUMNAME Forum OutBox
;
   %%%ECHO Deleting outgoing Messages: &&MESSAGEPATH&&FORUMNAME.SND
; At This point the Mail File Is No Longer Needed
   %%%REMOVEACTION &&FORUMNAME Send.Replies
   %%%KILLFILE &&MESSAGEPATH&&FORUMNAME.SND

[SET HIGH MESSAGE COUNTER]
;
; Set The High Message Counter to High Values
;
    %%SEND HIGH;L^M
    %%WAIT !

[OVERWRITE MESSAGES]
;
; Create New or Erase Existing &&FORUMNAME.MSG File if found to exist.
;
    %%KILLFILE &&MESSAGEPATH&&FORUMNAME.MSG

[PROMPT CATALOG]
;
; Ask what to do if a Library Catalog exists for this Forum on Disk
;
   %%IF FILEEXISTS &&CONTROLPATH&&FORUMNAME.LBR
   %%%ASK OVERWRITE? &&CONTROLPATH&&FORUMNAME.LBR  Do you want to Overwrite or Append to the &&FORUMNAME Catalog File?^M^J&&CONTROLPATH&&FORUMNAME.LBR
   %%%@SETERRORLEVEL 3 FALSE
   %%@SETERRORLEVEL 3 TRUE

[APPEND CATALOG]
;
; Append to Existing Library Catalog
;
   %%SETERRORLEVEL 3 TRUE

[OVERWRITE CATALOG]
;
; Overwrite the existing Catalog
;
   %%KILLFILE &&CONTROLPATH&&FORUMNAME.LBR
   %%SETERRORLEVEL 3 TRUE

[SHORT CATALOG SCAN]
;
; Requesting Download Information on &&SCANDESC
;
    %%%ECHO Scanning Libraries of &&FORUMNAME, &&FORUMTITLE
    %%%SCAN &&CONTROLPATH&&FORUMNAME.LBR LIST &&SCANFILE &&SCANLIBS &&SCANAGE &&SCANKEYWORDS
    %%%REMOVEACTION &&FORUMNAME Scan.Libraries
;

[FULL CATALOG SCAN]
;
; Requesting Download Information on &&SCANDESC
;
    %%%ECHO Scanning Libraries of &&FORUMNAME, &&FORUMTITLE
    %%%SCAN &&CONTROLPATH&&FORUMNAME.LBR SCAN &&SCANFILE DES &&SCANLIBS &&SCANAGE &&SCANKEYWORDS
    %%%REMOVEACTION &&FORUMNAME Scan.Libraries
;

[RESET SCAN CATALOG]
;
;  At this Point Library Scans are Complete so Kill Then Search Pattern Index
;
    %%%KILLFILE &&CONTROLPATH&&FORUMNAME.LXC

[DOWNLOAD FILES]
    %%DOWNLOAD &&DOWNLOADFILE &&DOWNLOADPATH &&DOWNLOADUPLD
;          Title: &&DOWNLOADTITLE
;          Library# &&LIBRARY, &&DOWNLOADSIZE Bytes, As of &&DOWNLOADDATE
;

[RESET DOWNLOAD FILES]
;
;  At this Point Downloads are Complete so Kill Then Download Tag List
;
    %%REMOVEACTION &&FORUMNAME Download.Files	
    %%KILLFILE &&CONTROLPATH&&FORUMNAME.LXR

[UPLOAD FILES]
;
; Sending Files
;                           <To be defined>
    %REMOVEACTION &&FORUMNAME Upload.Files	
;
