{$I WCDEFINE.INC}

unit WcType;

(**************************************************************************

Global record structure for Wildcat! version 4.0.
Copyright 1986,94 Mustang Software Inc. All rights reserved.

Last Revised 04-07-94

Revision 'P'

Resonsibility: Paul Davis

**************************************************************************)

interface

uses
  Dos
{$IFDEF OPRO}
  ,OpDate;
{$ELSE}
  {$IFDEF TPro}
  ,TpDate;
  {$ELSE}  {!!.N}
  ;

type
  Date = Word;
  Time = LongInt;
  DateTimeRec = record
    D : Date;
    T : Time;
  end;
  {$ENDIF}
{$ENDIF}

(***** Maximum limits ****************************************************)

const
  MaximumConfs    = 32760;
  MaximumFiles    = 32760;
  MaximumMsgs     = 65520;
  MaximumProfiles = 1000;
  MaximumDoors    = 1000;
  MaximumIdle     = 1000;
  MaximumLang     = 1000;

(***** Various bit set types *********************************************)

type
  PNodeInfoBits   = ^TNodeInfoBits;
  TNodeInfoBits   = array [1..32] of Byte;
  TArray1000Bits  = array [1..126] of Byte;
  TArray32768Bits = array [1..4096] of Byte;

(***** Modem profile file (*.MDM) ****************************************)

const
  mpFixedRate  = $01;
  mpCtsRtsFlow = $02;
  mpDropOnExit = $04;

type
  TGetBaud   = (gbResult1, gbResult2, gbByCR, gbDTE);
  TAnswer    = (aRing, aResult, aAutoAnswer);
  TInterface = (iSerial, iDigiboard, iFossil, iNone);
  TBaudType  = (bNone, b300, b1200, b2400, b4800, b7200, b9600, b12000,
                b14400, b16800, b19200, b28800, b38400, b57600, b115200);

const
  BaudNumber : array [TBaudType] of LongInt = (0, 300, 1200, 2400, 4800, 7200,
                                               9600, 12000, 14400, 16800, 19200,
                                               28800, 38400, 57600, 115200);

type
  PModemProfilePtr  = ^TModemProfile;
  TModemProfile     = record
                        Version       : Word;
                        ModemName     : String[30];
                        InitBaud      : LongInt;
                        CommPort,
                        CommIrq,
                        CarrierDelay,
                        pFlags,
                        FifoTrigger   : Byte;
                        CommBase,
                        RingDelay,
                        DropDtrDelay,
                        PreLogDelay,
                        ResultDelay,
                        ResetDelay    : Word;
                        AnswerPhone   : TAnswer;
                        DetermineBaud : TGetBaud;
                        InterfaceType : TInterface;
                        RingStr,
                        AnswerStr,
                        CallerIdStr,                  {!!.P}
                        ModemReset,
                        OnHook,
                        OffHook,
                        ErrorStr,
                        ModemInit     : String[60];
                        BaudStrings   : array [1..20] of String[20];
                        BaudRates     : array [1..20] of LongInt;
                        DumpStr,
                        ResetStr,
                        WriteStr      : String[10];
                        SetupStr      : array [1..3] of String[40];
                        Notes         : array [1..3] of String[64];
                        Reserved      : array [1..50] of Byte;
                      end;

(***** Makewild file (MAKEWILD.DAT) **************************************)

const
  mwLogOffIfNotVerified = $00000001;
  mwSysopDropToDos      = $00000002;
  mwShowSec             = $00000004;
  mwUseClearScreens     = $00000008;
  mwFreeFormPhone       = $00000010;
  mwReserved1           = $00000020;
  mwOverwriteChatFiles  = $00000040;
  mwLockOutForSecError  = $00000080;
  mwReserved2           = $00000100;
  mwDynamicFileKeys     = $00000200;
  mwSysopReadPrivate    = $00000400;
  mwShowUserSec         = $00000800;
  mwPrinterOnline       = $00001000;
  mwBulletsOptional     = $00002000;
  mwTerminateOnDoors    = $00004000;
  mwAutoId              = $00008000;
  mwForce8N1            = $00010000;
  mwReserved3           = $00020000;
  mwCopyOnCD            = $00040000;
  mwIndexLongDesc       = $00080000;
  mwAllowLocalUpgrades  = $00100000;
  mwPreferredChatMode   = $00200000;
  mwLanguageAtLogon     = $00400000;

  mwTCBulletins         = $0001;
  mwTCNews              = $0002;
  mwTCFiles             = $0004;
  mwTCDetailDL          = $0008;
  mwTCCheckDups         = $0010;
  mwTCFaxSupport        = $0020;

  mwCTUserAliasAllowed  = $00000001;
  mwCTActionWords       = $00000002;
  mwCTPaging            = $00000004;
  mwCTPrivateChan       = $00000008;
  mwCTChangeTopic       = $00000010;

type
  TModerate        = (mdAll, mdPrivate, mdPublic, mdNone);
  TSwapMethod      = (tDisk, tEms, tXms, tNoSwap);
  TMonitorType     = (sColor, sMono, sAuto);
  TSystemAccess    = (cOpen, cClosed, cClosedComment, cClosedQuestionnaire);
  TDBProtect       = (dbNone, dbMarkMode, dbSaveMode);
  TScreenBlank     = (sbNone, sbBox, sbBlackOut);
  TConsoleSec      = (csNone, csPassword, csNoConsole);
  TSettingSec      = (ssYes, ssMessage, ssNo);
  TNetSupportType  = (NoNet, Novell, MsNet);
  TSavePacketLevel = (plNone, plNetStatus, plAll);
  TColorMenus      = (tAscii, tAnsi, tRIP);
  TDriveTable      = array [1..26] of Byte;
  TOverlayType     = (otDisk, otEms, otXms);
  TDupUserType     = (duNone, duNoneChk, duAllow);



  TCBaudLimitRec = record
                     MaxPacket : Word;
                     MaxConf   : Word;
                   end;

  TPackerRec = record
                 Letter          : Char;
                 Description     : String[30];
                 Extension       : String[3];
                 PackerExe       : String[8];
                 PackerCmdLine   : String[40];
                 UnpackerExe     : String[8];
                 UnpackerCmdLine : String[40];
               end;

  TExcludeBullRec = record
                     Conference : Word;
                     BullNumber : Word;
                    end;

  PMakeWildRec = ^TMakeWildRec;
  TMakeWildRec = record
                   MWVersion           : String[5];
                   SysopName           : String[25];
                   Reserved1           : String[5];
                   FirstCall           : String[25];
                   PacketId            : String[8];
                   Phone               : String[25];
                   BBSName             : String[30];
                   FileDataBasePath,
                   UserDataBasePath,
                   NodeInfoPath,
                   ReservedPath,
                   DoorFilePath,
                   ModemFilePath,
                   ChatFilePath,
                   LanguagePath        : DirStr;
                   NewuserSec          : String[10];
                   MonitorType         : TMonitorType;
                   CloseOption         : TSystemAccess;
                   Network             : TNetSupportType;
                   DatabaseMode        : TDBProtect;
                   ScreenBlankMode     : TScreenBlank;
                   ScrollBackBuffer    : Word;
                   ExtLtr              : array [1..10] of Char;
                   ExtUpBatch,
                   ExtDnBatch,
                   ExtName             : array [1..10] of String[12];
                   ExtBatchDriven      : array [1..10] of Boolean;
                   ExtraMemForOverlay,
                   NodeId,
                   SecTries            : Byte;
                   MaxFileAreas,
                   MaxConfAreas,
                   FirstCallLimit      : Word;
                   MwFlags             : LongInt;
                   DateFormat,
                   TimeFormat          : String[40];
                   RegString           : String[7];
                   FlexEventInactivity : Word;
                   FlexEventForceTime  : Time;
                   LockDriveTable      : TDriveTable;
                   DefaultExt          : ExtStr;
                   ThumbNailFile       : String[12];
                   ConsolePassword     : String[14];
                   ConsoleSec          : TConsoleSec;
                   ChangePhone,
                   ChangeAlias,
                   ChangeBDate         : TSettingSec;
                   SwapMethod          : TSwapMethod;
                   Packer              : array [1..10] of TPackerRec;
                   TCCity              : String[30];
                   TCFlags             : Word;
                   PreScanArea         : Word;
                   SavePacketLevel     : TSavePacketLevel;
                   TCMaxPerBaud        : array [TBaudType] of TCBaudLimitRec;
                   TCExcludeBulls      : array [1..40] of TExcludeBullRec;
                   MaxChannelSize      : Word;
                   ChatTimeOut         : Word;
                   TalkTimeOut         : Word;
                   ChatWaitTime        : Byte;
                   ChatModerate        : TModerate;
                   ChatFlags           : LongInt;
                   ModemProfile        : TModemProfile;
                   HoldOverlay         : TOverlayType;
                   DupUserLevel        : TDupUserType;
                   Reserved            : array [1..198] of Byte;
                 end;

(***** Security profiles (SECLEVEL.DAT) **********************************)

type
  TSysopAccess    = (saNo, saYes, saMaster, saNetStatus);
  TRatioAction    = (raNothing, raWarn, raNoDownloads);
  TMenuItemAccess = array [1..8] of Byte;
  TProfileType    = (ptFullProfile, ptSecondary);
  TUploadType     = (utNoDupes, utWarnOfDupe, utIgnore);

const
  pfAscii         = $00000001;
  pfXmodem        = $00000002;
  pfXmodemCrc     = $00000004;
  pfXmodem1k      = $00000008;
  pfXmodem1kG     = $00000010;
  pfYmodem        = $00000020;
  pfYmodemG       = $00000040;
  pfKermit        = $00000080;
  pfZmodem        = $00000100;
  pfExternal1     = $00000200;
  pfExternal2     = $00000400;
  pfExternal3     = $00000800;
  pfExternal4     = $00001000;
  pfExternal5     = $00002000;
  pfExternal6     = $00004000;
  pfExternal7     = $00008000;
  pfExternal8     = $00010000;
  pfExternal9     = $00020000;
  pfExternal10    = $00040000;

  sfFastLogin     = $00080000;
  sfOverwrite     = $00100000;
  sfShowPWFiles   = $00200000;
  sfTCFileAccess  = $00400000;
  sfUpOverTime    = $00800000;
  sfDnOverTime    = $01000000;
  sfDictionary    = $02000000;
  sfDistMail      = $04000000;
  sfModifyUpload  = $08000000;

  cfChatSysop     = $0001;
  cfActionWords   = $0002;
  cfUninvite      = $0004;
  cfPageUsers     = $0008;
  cfModerator     = $0010;
  cfChatAlias     = $0020;

  sConfRead       = $01;
  sConfWrite      = $02;
  sConfJoin       = $04;

  sFileList       = $01;
  sFileDown       = $02;
  sFileUp         = $04;

type
  PSecHeader = ^TSecHeader;
  TSecHeader = record
                 ProfileName : String[10];
                 ProfileType : TProfileType;
               end;

  PSecRec = ^TSecRec;
  TSecRec = object
              ProfileName     : String[10];
              ProfileType     : TProfileType;
              ExpiredName     : String[10];
              DisplayName     : String[8];
              NodeAccess      : TNodeInfoBits;
              DoorAccess      : TArray1000Bits;
              MenuItemAccess  : TMenuItemAccess;
              SysopStatus     : TSysopAccess;
              RatioAction     : TRatioAction;
              UploadComp,
              MaxRatio        : Byte;
              Menus           : Char;
              ChatFlags       : Word;
              sFlags          : LongInt;
              ExpireDate      : Date;
              DailyTimeLimit,
              MaxLogon,
              VerifyBDate,
              VerifyPhone,
              MaxDL,
              MaxDK,
              MaxKRatio,
              MaxConfAreas,
              MaxFileAreas,
              FaxFlags        : Word;
              DoorProfile     : String[10];
              UploadAccess    : TUploadType;
              Reserved        : array [1..36] of Byte;
            end;

(***** Conference name list (CONFDESC.IX, CONFDESC.UX) *******************)

type
  TConfList = record
                ConfName : String[25];
                ConfNum  : Word;
              end;

(***** Conference list (CONFDESC.DAT) ************************************)

const
  cfPromptToKillMsg    = $0001;
  cfHighAscii          = $0002;
  cfAllowCarbon        = $0004;
  cfReserved1          = $0008;
  cfReserved2          = $0010;
  cfReturnReceipt      = $0020;
  cfLongAddress        = $0040;
  cfUseAlias           = $0080;
  cfAllowAttach        = $0100;
  cfPromptToKillAttach = $0200;
  cfShowCtrlLines      = $0400;

type
  TMailType  = (mtNormalPublicPrivate,
                mtNormalPublic,
                mtNormalPrivate,
                mtFidoNetmail,
                mtInternetEmail,
                mtInternetNewsgroup);
  TValidName = (vnYes, vnNo, vnPrompt);

const mtAllowPrivate = [mtNormalPublicPrivate,
                        mtNormalPrivate,
                        mtFidoNetmail,
                        mtInternetEmail];
      mtForcePrivate = [mtNormalPrivate,
                        mtFidoNetmail,
                        mtInternetEmail];

type
  PConfDesc = ^TConfDesc;
  TConfDesc = record
                ConfName,
                ConfOp        : String[25];
                ConfShortName : String[12];
                ConfMail      : TMailType;
                DoorAccess    : TArray1000Bits;
                BullPath,
                QuesPath,
                MenuPath,
                HelpPath,
                DisplayPath,
                MsgPath,
                AttachPath    : DirStr;
                Reserved1     : Byte;
                cFlags,
                ConfNumber    : Word;
                ValidNames    : TValidName;
                MaxMessages,
                MaxFileAreas  : Word;
                Reserved      : array [1..50] of Byte;
              end;

(***** File area name file (FILEAREA.IX, FILEAREA.UX) ********************)

type
  TFileList = record
                AreaName   : String[30];
                AreaNumber : Word;
              end;

(***** File area file (FILEAREA.DAT) *************************************)

type
  PFileAreaRec = ^TFileAreaRec;
  TFileAreaRec = record
                   AreaName : String[30];
                   AreaPath : DirStr;
                   Reserved : array [1..20] of Byte;
                 end;

(***** Language file (LANGDESC.DAT) **************************************)

type
  PLangDesc = ^TLangDesc;
  TLangDesc = record
                Language    : String[8];
                Description : String[73];
                YesChar     : Char;
                NoChar      : Char;
              end;

(***** Door file (DOOR.DAT) **********************************************)

const
  diMultiUser = $01;
  diInUse     = $02;
  diMenuHook  = $04;

type
  TDoor = record
            diName   : String[20];
            diBat    : String[8];
            diDisp   : String[8];
            diFlags  : Byte;
            Reserved : array [1..20] of Byte;
          end;

(***** Idle program data (ILDEPGM.DAT) ***********************************)

type
  PIdleProgram = ^TIdleProgram;
  TIdleProgram = record
                   Name      : String[30];
                   ShellPath : PathStr;
                   Password  : String[14];
                   Reserved  : array [1..20] of Byte;
                 end;

(***** Master info file (NODEINFO.DAT record 0) **************************)

type
  PMasterInfo = ^TMasterInfo;
  TMasterInfo = record
                  VersionId     : String[5];
                  ActiveNodes   : TNodeInfoBits;
                  TotalCalls,
                  TotalUsers,
                  TotalFiles,
                  TotalMessages : LongInt;
                  TempCalls,
                  TempMsgs,
                  TempDownloads,
                  TempUploads   : Word;                   {!!.P}
                  ReservedWords : array[1..8] of Byte;    {!!.P}
                  TempReset     : DateTimeRec;
                  HighestUserId : LongInt;
                  ChatCount     : Byte;
                  Reserved      : array [1..160] of Byte;
                end;

(***** Nodeinfo file (NODEINFO.DAT) **************************************)

const
  niLptr        = $00000001;
  niPage        = $00000002;
  niBell        = $00000004;
  niKybd        = $00000008;
  niLocalNext   = $00000010;
  niScreenWrite = $00000020;
  niEventNext   = $00000040;
  niBringDown   = $00000080;
  niKillCaller  = $00000100;
  niPagingSysop = $00000200;
  niOnLocally   = $00000400;
  niMNPConnect  = $00000800;
  niSysopNext   = $00001000;
  niUseVgaMode  = $00002000;
  niCapture     = $00004000;
  niStayDown    = $00008000;

type
                                                                                     {vvGo Awayvv}
  TNodeStatus = (nsDown, nsUp, nsSigningOn, nsLoggedIn, nsEventProcessing, nsRepair, nsReceiveFax); {!!.J}
  TUserStatus = (usNone, usFileTransfer, usEnteringMsg, usInDoor, usInDOS, usPChat, usDChat);
  TSysWindow  = (swNoWindow, swSingleWindow, swOrigWindow, swBigWindow);

  PNodeInfo = ^TNodeInfo;
  TNodeInfo = record
                Security      : String[10];
                NodeStatus    : TNodeStatus;
                UserStatus    : TUserStatus;
                SysWindow     : TSysWindow;
                CallersName   : String[25];
                From          : String[30];
                PrevCaller    : String[50];
                UserID        : LongInt;
                BaudRate      : LongInt;
                TimeCalled,
                PrevLogOff,
                TimeOff       : DateTimeRec;
                RequestNode   : Integer;
                CallerNumber,
                nFlags,
                QuoteIndex,
                LowestBaud    : LongInt;
                CurStatus     : String[20];
                {CurDoor,
                {CurConf       : Word;}
                NumberOfCalls : LongInt;
                Reserved      : array [1..50] of Byte;
              end;

(***** User database (ALLUSERS.DAT) **************************************)

const
  ufNeverDelete      = $00000001;
  ufChatPage         = $00000002;
  ufHotKey           = $00000004;
  ufLockedOut        = $00000008;
  ufQuoteOnReply     = $00000010;
  ufBellAtLogin      = $00000020;
  ufNoPrivMail       = $00000040;
  ufNoDelMail        = $00000080;
  ufTCNoPvtExport    = $00000100;
  ufTCSendFromYou    = $00000200;
  ufTCSendNewFiles   = $00000400;
  ufTCSendNewBulls   = $00000800;
  ufTCUploadHangup   = $00001000;
  ufTCAllAttachments = $00002000;
  ufTCScanPrivate    = $00004000;
  ufTCScanFaxes      = $00008000;
  ufTCScripts        = $00010000;
  ufSortedLists      = $00020000;
  ufCrashMail        = $00040000;
  ufFileAttach       = $00080000;
  ufCaptureUser      = $00100000;
  ufSevenBitAscii    = $00200000;

const
  cufSysopMail    = $01;
  cufSelected     = $02;
  cufLockedOut    = $04;
  cufTitleOff     = $08;
  cufPersonalOnly = $10;
  cufScanAll      = $20;

type
  TPacketType = (pText, pQwk);
  TAutoPilot  = (apUpDn, apDnUp);

type
  TUserConfRecType = (ucrIndex, ucrData);

  PUserConfData = ^TUserConfData;
  TUserConfData = record
                    cuFlags       : Byte;
                    cuLastRead    : Word;
                    cuFirstUnread : Word;
                  end;

  PUserConfArray = ^TUserConfPage;
  TUserConfArray = array [0..1023] of TUserConfData;

  PUserConfPageHeader = ^TUserConfPageHeader;
  TUserConfPageHeader = record
                          RecLen   : Word;
                          RecType  : TUserConfRecType;
                          UserID   : LongInt;
                          Page     : Integer;
                          This     : Longint;
                        end;

  PUserConfPage = ^TUserConfPage;
  TUserConfPage = record
                    RecLen       : Word;
                    RecType      : TUserConfRecType;
                    UserID       : LongInt;
                    Page         : Integer;
                    This         : Longint;
                    UserConfData : TUserConfArray;
                  end;

  TUserConfIndex = record
                     RecLen  : Word;
                     RecType : TUserConfRecType;
                     offsets : array [0..31] of Longint;
                   end;

type
  TEditor         = (ePrompt, eNormal, eFullScreen);
  TMorePrompt     = (mpErasePrompt, mpNextLine);
  TFileDisplay    = (fdSingleLine, fdDoubleLine, fdFull);
  TExpertiseLevel = (elNovice, elRegular, elExpert);
  TSex            = (sUnKnown, sMale, sFemale);
  TMsgDisplay     = (mdScroll, mdClear, mdHeader);
  TScrnDisplay    = (sdNoColor, sdColor, sdRip, sdAuto);
  TProtocol       = (pAll, pXmodem, pXmodemCRC, pYmodem, pYmodemG, pXmodem1K,
                     pXmodem1KG, pKermit, pZmodem, pAscii, pExt1, pExt2, pExt3,
                     pExt4, pExt5, pExt6, pExt7, pExt8, pExt9, pExt10);

  TSecondarys = array[1..5] of String[10];

  PUserRec = ^TUserRec;
  TUserRec = object
               Status               : LongInt;
               UserName             : String[25];
               From                 : String[30];
               Password             : String[14];
               UserID               : LongInt;
               PhoneNumber,
               DataNumber,
               FaxNumber,
               ComputerType         : String[15];
               SecLevel             : String[10];
               Secondary            : TSecondarys;
               Company,
               Address1,
               Address2,
               City                 : String[30];
               State                : String[15];
               Zip                  : String[10];
               Country              : String[25];
               Title                : String[10];
               Alias                : String[25];
               NovellName           : String[8];
               Language             : String[8];
               Comment              : array [1..5] of String[30];
               Sex                  : TSex;
               Editor               : TEditor;
               MorePrompt           : TMorePrompt;
               Xpert                : TExpertiseLevel;
               TransferMethod       : TProtocol;
               ScreenDisplay        : TScrnDisplay;
               FileDisplay          : TFileDisplay;
               MsgDisplay           : TMsgDisplay;
               LinesPerPage         : Byte;
               LastCall,
               LastNewFiles         : DateTimeRec;
               ExpireDate,
               MemoDate,
               UserSince,
               BirthDate            : Date;
               ActiveConf,
               MsgsWritten,
               Uploads,
               Downloads,
               TimesOn,
               TimeLeft             : Word;
               UFlags,
               DailyDL,
               DailyDK,
               TotalUK,
               TotalDK,
               MinutesLogged,
               SubScriptionBalance,
               NetMailBalance       : LongInt;
               TCAutoPilot          : TAutoPilot;
               TCPacket             : TPacketType;
               TCPacker             : Char;
               TCMaxPerConf         : Word;
               TCMaxPerPacket       : Word;
               TCMaxAttachSize      : Word;
               UserConfData         : Longint;
               Reserved             : array [1..50] of Byte;
             end;

(***** Message files (MSGxxx.IX) *****************************************)

const
  mfPrivate     = $0001;
  mfReceiveable = $0002;
  mfReceived    = $0004;
  mfReceipt     = $0008;
  mfCarboned    = $0010;
  mfForwarded   = $0020;
  mfEchoFlag    = $0040;
  mfHasReplies  = $0100;
  mfDeleted     = $0200;
  mfTagged      = $0400;
  mfSent        = $0800;

type
  TFidoAddress = record
                   Zone,
                   Net,
                   Node,
                   Point : Word;
                 end;

  PMsgText = ^TMsgText;
  TMsgText = array [0..65519] of Char;

  PMsgHeader = ^TMsgHeader;
  TMsgHeader = record
                 MagicNumber    : Longint;
                 MsgNumber      : Word;
                 Orig           : String[70];
                 OrigTitle      : String[10];
                 OrigUserID     : LongInt;
                 Dest           : String[70];
                 DestTitle      : String[10];
                 DestUserID     : LongInt;
                 Subject        : String[70];
                 Network        : String[8];
                 MsgTime        : DateTimeRec;
                 ReadTime       : DateTimeRec;
                 mFlags         : Word;
                 Reference      : Word;
                 FidoFrom       : TFidoAddress;
                 FidoTo         : TFidoAddress;
                 MsgBytes       : Word;
                 InternalAttach : String[12];
                 ExternalAttach : String[12];
                 PrevUnread     : Word;
                 NextUnread     : Word;
                 FidoFlags      : Word;
                 Reserved       : array [1..24] of Byte;
               end;

  TMsgIndexHeader = record { must be same size as TMsgIndexEntry }
                      RecordSize    : Word;
                      ActiveRecords : Word;
                      NextMsgNumber : Word;
                    end;

  TMsgIndexEntry = record { must be same size as TMsgIndexHeader }
                     MsgNumber    : Word;
                     HeaderOffset : Longint;
                   end;

(***** File database (ALLFILES.DAT) **************************************)

const
  fiNeverOverwrite   = $0001;
  fiNeverDelete      = $0002;
  fiDontCharge       = $0004;
  fiUploadInProgress = $0008;
  fiOnCD             = $0010;
  fiOffLine          = $0020;
  fiFailedScan       = $0040;
  fiFreeTime         = $0080;

type
  PFileMsgText = ^TFileMsgText;
  TFileMsgText = array [0..1200] of Byte;
  TKeyArray    = array [1..6] of String[10];

  PFileRec = ^TFileRec;
  TFileRec = record
               Status,
               Size         : LongInt;
               FileName     : String[12];
               Password     : String[14];
               FileTime,
               LastAccessed : DateTimeRec;
               Uploader     : String[25];
               UploaderID   : LongInt;
               Desc         : String[75];
               MsgBytes,
               fFlags,
               NumOfAccess,
               Cost,
               Area         : Word;
               Keywords     : TKeyArray;
               StoredPath   : PathStr;
               MsgText      : TFileMsgText;
             end;

  PFileHeader = ^TFileHeader;
  TFileHeader = record
                  Status,
                  Size         : LongInt;
                  FileName     : String[12];
                  Password     : String[14];
                  FileTime,
                  LastAccessed : DateTimeRec;
                  Uploader     : String[25];
                  UploaderID   : LongInt;
                  Desc         : String[75];
                  MsgBytes,
                  fFlags,
                  NumOfAccess,
                  Cost,
                  Area         : Word;
                  Keywords     : TKeyArray;
                  StoredPath   : PathStr;
                end;

(***** Menu file (xxx.MNU) ***********************************************)

type
  TMenuCommand = (
  (***** Main menu *****)
    cmBulletins,
    cmDoorMenu,
    cmSysopComment,
    cmPageSysop,
    cmShowHellos,
    cmQuestionnaires,
    cmLocateUser,
    cmChangeSettings,
    cmStatistics,
    cmUsersList,
    cmNewsLetter,
    cmWhoIsOnline,
  (***** Message menu *****)
    cmReadMessage,
    cmScanMessages,
    cmEnterMessage,
    cmDeleteMessage,
    cmCheckMailAtMenu,
    cmUpdateConfScans,
    cmMailDoor,
  (***** File menu *****)
    cmFullFileInfo,
    cmListFilesByArea,
    cmDownloadFiles,
    cmUploadFiles,
    cmListFilesByDate,
    cmSearchFiles,
    cmFileStats,
    cmPersonalStats,
    cmViewArcFile,
    cmReadAFile,
    cmEditMarkList,
  (***** Sysop menu *****)
    cmManageEvents,
    cmEditUserRec,
    cmReadActLog,
    cmEraseActLog,
    cmEditFileRec,
    cmSysopStatus,
    cmEditNodes,
    cmSysopDownload,
    cmSysopUpload,
  (***** Global options *****)
    cmChangeConference,
    cmRunQuesFile,
    cmXpertLevel,
    cmDumpHelpFile,
    cmDisplayMenuFile,
    cmDisplayDispFile,
    cmDisplayTxtFile,
    cmDisplayBulletin,
    cmLogoffUser,
    cmRunScript,
    cmGotoMenu,
    cmMenuHook,
    cmStackCommands,
    cmPageUser,
    cmReturnPressed,
    cmInvalidCommand
  );

const
  MaxMenuItems = 40;

  mufChangeConf = $01;
  mufTopLevel   = $02;

type
  PMenuItem = ^TMenuItem;
  TMenuItem = record
                Selection   : Char;
                CommandDesc : String[30];
                CommandId   : TMenuCommand;
                CommandParm : Boolean;
                CommandStr  : String[40];
                CommandNum  : Word;
              end;

  PMenuRec = ^TMenuRec;
  TMenuRec = record
               SecAccess  : TArray1000Bits;
               MenuFields : Byte;
               MenuDesc   : String[35];
               MenuFile   : String[8];
               ConfNumber : Word;
               muFlags    : Byte;
               MenuItem   : array [1..MaxMenuItems] of TMenuItem;
             end;

(***** Event file (EVENTxxx.DAT) *****************************************)

const
  etSun = $01;
  etMon = $02;
  etTue = $04;
  etWed = $08;
  etThu = $10;
  etFri = $20;
  etSat = $40;

type
  TEventMethod   = (emFlex, emSoft, emHard);
  TEventShell    = (esShell, esTerminate);
  TEventSchedule = (esHourly, esDaily, esMonthly, esYearly);
  TEventAction   = (eaNoPage, eaResetStats, eaRunBatch, eaAllPageOff,
                    eaNodePage, eaDosNext, eaAllPageOn, eaBaudLimit,
                    eaRunScript, eaBellOn, eaBellOff, eaAllBellOn,
                    eaAllBellOff);  {!!.P}

  PEvent = ^TEvent;
  TEvent = record
             Method     : TEventMethod;
             Action     : TEventAction;
             BaudRate   : LongInt;
             Active     : Boolean;
             NextExec,
             LastExec   : DateTimeRec;
             DayBitSet  : Byte;
             ShellType  : TEventShell;
             BatchPath  : PathStr;
             Schedule   : TEventSchedule;
             HourDelay  : Byte;
             DayOfMonth : Byte;
             Month      : Byte;
           end;


(***** Chat file data (CHANNELS.DAT) *************************************)

type
  TChannelStatus = (csNotInUse, csPublic, csPrivate, csModerated, csPriMod);

  PChannelRecord = ^TChannelRecord;
  TChannelRecord = record
                     FName      : String[8];
                     DispFile   : String[8];
                     Name       : String[25];
                     ModName    : String[25];
                     ActionFile : String[8];
                     Topic      : String[30];
                     ChanStatus : TChannelStatus;
                     Moderator  : Word;
                     Users      : Word;
                     MaxUsers   : Word;
                     LogChannel : Boolean;
                     Profanity  : Boolean;
                     SecAccess  : TArray1000Bits;
                   end;

(***** Action word file (*.ACT) ******************************************)

type
  PActionRecord = ^TActionRecord;
  TActionRecord = record
                    KeyWord      : String[10];
                    ToOriginator : String[80];
                    ToTarget     : String[80];
                    ThirdPerson  : String[80];
                    NoTarget     : String[80];
                  end;

implementation

end.
