/*
 * Waterloo TCP
 *
 * Copyright 1991, University of Waterloo
 *
 * This library is free software; you can use it or redistribute under
 * the terms of the license included in LICENSE.H.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * file LICENSE.H for more details.
 *
 * This network library was created by Erick Engelke of the University of
 * Waterloo, Waterloo, Ontario, Canada.
 *
 * Name resolution services were adapted from sources made available by
 * the National Centre for Supercomputer Applications (NCSA) and Clarkson
 * University.
 *
 */

#ifdef OLD
#define sock_Read       sock_read
#define sock_FastRead   sock_fastread
#define sock_Write      sock_write
#define sock_FastWrite  sock_fastwrite
#define sock_Flush      sock_flush
#define sock_FlushNext  sock_flushnext
#define sock_Puts       sock_puts
#define sock_Gets       sock_gets
#define sock_Putc       sock_putc
#define sock_Getc       sock_getc
#define sock_DataReady  sock_dataready
#define sock_Close      sock_close
#define sock_Abort      sock_abort
#define sock_Printf     sock_printf
#define sock_Scanf      sock_scanf

#define udp_Open        udp_open
#define tcp_Open        tcp_open
#define tcp_Listen      tcp_listen
#endif OLD

/* Kernal version (major major minor minor) */
#define WTCP_VER 0x0102

/*
 * Typedefs and constants
 */

#ifndef byte
typedef unsigned char byte;
#endif  byte
#ifndef word
typedef unsigned int word;
#endif  word
#ifndef longword
typedef unsigned long longword;
#endif  longword

typedef struct {
    byte undoc[ 4300 ];
} tcp_Socket;

typedef struct {
    byte undoc[ 2200 ];
} udp_Socket;


typedef struct sockaddr {
    word        s_type;
    word        s_port;
    longword    s_ip;
    byte        s_spares[6];    /* unused in TCP realm */
};


#define MAX_COOKIES     10
#define MAX_NAMESERVERS 10

#define TCP_MODE_BINARY 0
#define TCP_MODE_ASCII	1
#define UDP_MODE_CHK	0	/*default to checksum */
#define UDP_MODE_NOCHK	2
#define TCP_MODE_NAGLE  0       /* Nagle algorithm */
#define TCP_MODE_NONAGLE 4

sock_init();
/*
 *   s is the pointer to a udp or tcp socket
 */
sock_read(void  *s, byte *dp, int len );
sock_fastread(void  *s, byte *dp, int len );
sock_write(void  *s, byte *dp, int len);
void sock_enqueue(void  *s, byte *dp, int len);
sock_fastwrite(void *s, byte *dp, int len );
sock_flush( void  *s );
sock_flushnext( void  *s);
sock_puts( void  *s, byte *dp );
word sock_gets( void  *s, byte *dp, int n );
byte sock_putc( void  *s, byte c );
byte sock_getc( void  *s );
word sock_dataready( void  *s );
sock_close( void *s );
sock_abort( void *s );
sock_printf( void  *s, char *format, ... );
sock_scanf( void  *s, char *format, ... );
sock_mode( void *s, word mode );	/* see TCP_MODE_... */
db_write( char *msg );
dbuginit();

/*
 * TCP or UDP specific stuff, must be used for open's and listens, but
 * sock stuff is used for everything else
 */
int udp_open(void *s, word lport, longword ina, word port, int (*datahandler)());
int tcp_open(void *s, word lport, longword ina, word port, int (*datahandler)());
tcp_listen(void *s, word lport, longword ina, word port, int (*datahandler)(), word timeout);
int tcp_established(void *s);

char *rip( char *s );
longword resolve( char *name);
/*
 * less general functions
 */
longword aton( char *text );
int isaddr( char *text );
tcp_cbreak( word mode );
longword intel( longword x );
word intel16( word x );

/*
 * timers
 */

void ip_timer_init( void *s , word delayseconds );
word ip_timer_expired( void *s );



        /*
         * TCP/IP system variables - do not change these since they
         *      are not necessarily the source variables, instead use
         *      ip_Init function
         */
extern longword my_ip_addr;
extern longword sin_mask;       /* eg.  0xfffffe00L */
extern word sock_delay;

        /*
         * tcp_init/tcp_shutdown
         *      - init/kill all tcp and lower services
         *      - only call if you do not use sock_init
         * (NOT RECOMMENDED)
         */
tcp_shutdown();
tcp_Init();

/*
 * things you probably won't need to know about
 */
	/*
	 * sock_debugdump
	 *	- dump some socket control block parameters
	 * used for testing the kernal, not recommended
	 */
sock_debugdump( void *s);
        /*
         * tcp_config - read a configuration file
         *            - if special path desired, call after sock_init()
         *            - null reads path from executable
         * see sock_init();
         */
tcp_config( char *path );
        /*
         * tcp_tick - called periodically by user application in sock_wait_...
         *          - returns 1 when our socket closes
         */
tcp_tick( void *s );
        /*
         * Retransmitter - called periodically to perform tcp retransmissions
         *          - normally called from tcp_tick, you have to be pretty
         *            low down to use this one
         */
tcp_Retransmitter();
        /*
         * tcp_set_debug_state - set 1 or reset 0 - depends on what I have done
         */
tcp_set_debug_state( word x );


extern int _last_cookie;
extern longword _cookie[MAX_COOKIES];

        /*
         * name domain constants
         */

extern char *def_domain;
extern longword def_nameservers[ MAX_NAMESERVERS ];


extern word wathndlcbrk;
extern word watcbroke;
/*
 * sock_wait_... macros
 */
/*
 * sock_wait_established()
 *	- waits then aborts if timeout on s connection
 * sock_wait_input()
 *	- waits for received input on s
 *	- may not be valid input for sock_Gets... check returned length
 * sock_tick()
 *	- do tick and jump on abort
 * sock_wait_closed();
 *	- discards all received data
 *
 * jump to sock_err with contents of *statusptr set to
 *	 1 on closed
 *	-1 on timeout
 *
 */
int _ip_delay0( void *s, int seconds, int (*fn)(), void *statusptr );
int _ip_delay1( void *s, int seconds, int (*fn)(), void *statusptr );
int _ip_delay2( void *s, int seconds, int (*fn)(), void *statusptr );

unsigned long set_timeout( unsigned int seconds );
unsigned long set_ttimeout( unsigned int ticks );
int chk_timeout( unsigned long timeout );



int tcp_tick( void *s );

#define sock_wait_established( s, seconds, fn, statusptr ) \
    if (_ip_delay0( s, seconds, fn, statusptr )) goto sock_err;
#define sock_wait_input( s, seconds, fn , statusptr ) \
    if (_ip_delay1( s, seconds, fn, statusptr )) goto sock_err;
#define sock_tick( s, statusptr ) \
    if ( !tcp_tick(s)) { if (statusptr) *statusptr = 1 ; goto sock_err; }
#define sock_wait_closed(s, seconds, fn, statusptr )\
    if (_ip_delay2( s, seconds, fn, statusptr )) goto sock_err;

/* user initialization file */
extern void (*usr_init)();

void outs( char far * string );
longword aton( char * string);
int _ping( longword host , longword countnum );
longword _chk_ping( longword host , longword *ptr);
void _arp_register( longword use, longword instead_of );



void _eth_init();
byte *_eth_formatpacket( void *eth_dest, word eth_type );
void _eth_send( word len);
void _eth_free( void *buf);
byte *_eth_arrived( word *type_ptr);
void _eth_release();



/* bsd-similar stuff */

int sock_rbsize( void *s );
int sock_rbused( void *s );
int sock_rbleft( void *s );
int sock_tbsize( void *s );
int sock_tbused( void *s );
int sock_tbleft( void *s );


_chk_socket( tcp_Socket *s );
char *inet_ntoa( char *s, longword x );
char *psocket( tcp_Socket *s );
longword inet_addr( char *s );
char *sockerr( tcp_Socket *s );
char *sockstate( tcp_Socket *s );
getpeername( tcp_Socket *s, void *dest, int *len );
getsockname(  tcp_Socket *s, void *dest, int *len );
longword gethostid();
longword sethostid( longword ip );
char *getdomainname( char *name, int length );
char *setdomainname( char *string );
char *gethostname( char *name, int length );
char *sethostname( char *string );
word ntohs( word a );
word htons( word a );
longword ntohl( longword x );
longword htonl( longword x );

void _arp_register( longword use, longword instead_of );
int _arp_resolve( longword ina, void *ethap);

extern _survivebootp;

sock_stats( tcp_Socket *s, word *days, word *inactive, word *cwindow, word *avg, word *sd );
int addwattcpd( void (*p)() );
int delwattcpd( void (*p)() );
int tap_add( void *socket, void *userid );
