/*
 * TAP Support
 *
 * To add TAP support, you must call the tap_add() function at least once.
 * The first or successive calls can be used to change the default userid or
 * specific userids on a per-socket basis.
 *
 * tap_add( NULL, "joe" )   adds the default userid of joe
 * tap_add( NULL, NULL )    reverts the default userid back to the default
 * tap_add( socket, "joe" ) sets the specific socket to have userid joe
 * tap_add( socket, NULL )  tells the specific socket to keep current with the
 *                          default userid (and change when it does)
 *
 * NOTE: this is a system level service, it only includes <wattcp.h> because
 *       it resides BELOW the application layer.  Applications must always
 *       include <tcp.h> instead!
 */

#include <wattcp.h>

#define TAPPORT 113
#define S_INIT  0
#define S_WAIT  1
#define S_CONN  2   /* connected and talking */
#define S_CLOS  3

static tcp_Socket *taps = NULL;
static int tapstatus = S_INIT;
static char *root = "root";
static char *userid;


tap_tick()
{
    word hisport, myport;
    tcp_Socket *t;
    switch ( tapstatus ) {
        case S_INIT :   tcp_listen( taps, TAPPORT, 0L, 0, NULL, 0 );
                        sock_mode( taps, TCP_MODE_ASCII );
                        tapstatus = S_WAIT;
                        break;
        case S_WAIT :   if ( sock_established( taps )) tapstatus = S_CONN;
                        if ( ! tcp_tick( taps )) s->status = S_CLOS;
                        break;
        case S_CONN :   if ( sock_dataready( taps )) {
                            sock_scanf( taps, "%u,%u", &myport, &hisport );
                            /* must find appropriate socket */
                            if ( t = _tcp_lookup( taps->hisaddr, hisport, myport ))
                                sock_printf( taps,
                                    "%u, %u : USERID : OTHER : %s",
                                        myport, hisport,
                                        (t->usr_name)? t->usr_name : userid );
                            else
                                sock_printf( taps,
                                    "%u, %u : ERROR : UNKNOWN-ERROR",
                                        myport, hisport );
                            sock_close( taps );
                            s->status = S_CLOS;
                        }
                        if (!tcp_tick( taps )) {
                            sock_close( taps );
                            s->status = S_CLOS;
                        }
                        break;
            case S_CLOS :
                        sock_mode( taps, TCP_MODE_BINARY );
                        if ( sock_dataready( taps ))
                            sock_fastread( taps, NULL, 512 );
                        if ( !tcp_tick( t ) ) {
                            for ( count = i = 0; i < fingersessions; ++i )
                                if (fingers[i]->status != S_WAIT ) count++;
                            printf("CLOS : session %u --- %u capacity\n",
                                sess, (--count*100)/fingersessions );
                            s->status = S_INIT;
                        }
                        break;
        }
    }
}

tap_add( tcp_Socket *s, char *localuserid )
{
    char *p;
    /* check if we are initialized */
    if ( taps == NULL ) {
        taps = calloc( 1, sizeof( tcp_Socket ));
        addwattcpd( tap_tick );
    }

    /* check userid */
    if ( localuserid ) {
        for ( p = localuserid ; *p ; p++ ) {
            if ( (*p < 33) || (*p > 126)) {
                /* revert to default */
                if ( s ) localuserid = userid;
                else localuserid = root;
            }
        }
    }

    /* change system default userid or session based userid */
    if ( s == NULL ) userid = (localuserid) ? localuserid : root;
    else s->usr_name = (localuserid) ? localuserid : userid;
}

