#include <copyright.h>
#include <wattcp.h>
#include <elib.h>
#include <dos.h>


#define MAXBUFS 	5	/* maximum number of Ethernet buffers */
#define BUFSIZE     1500


#define INT_FIRST 0x60
#define INT_LAST  0x80
#define PKT_LINE "PKT DRVR"
#define PD_DRIVER_INFO	0x1ff
#define PD_ACCESS 	0x200
#define PD_RELEASE	0x300
#define PD_SEND		0x400
#define PD_GET_ADDRESS	0x600
#define  CARRY 		1	     /* carry bit in flags register */

word _pktipofs = 0;			/* offset from header to start of pkt */
word pkt_interrupt;
word pkt_ip_type = 0x0008;		/* these are intelled values */
word pkt_arp_type = 0x608;

byte pktbuf[MAXBUFS][ BUFSIZE + 2 ];	/* first byte is busy flag, 2nd spare */
word  pkt_ip_handle;
word  pkt_arp_handle;
byte eth_addr[ 6 ] ;
longword far *interrupts = 0L;



extern void _pktentry();
extern void _pktasminit( void far *, int, int );
extern int qcmp( void far *, void far *, int );


pkt_init()
{
    struct REGPACK regs, regs2;
    char far *temp;
    int pd_type;	/* packet driver type */
    int class;

    _pktasminit( pktbuf, MAXBUFS, BUFSIZE);
    for (pkt_interrupt = INT_FIRST; pkt_interrupt <= INT_LAST; ++pkt_interrupt ) {
	temp = getvect( pkt_interrupt );
	temp = (char far *)(interrupts[ pkt_interrupt ]);
	if ( !qcmp( &(temp[3]), PKT_LINE, sizeof( PKT_LINE ))) {
	    break;
	}
    }
    if ( pkt_interrupt > INT_LAST ) {
	outs("NO PACKET DRIVER FOUND");
	return( 1 );
    }

    /* lets find out about the driver */
    regs.r_ax = PD_DRIVER_INFO;
    intr( pkt_interrupt, &regs );

    /* handle old versions, assume a class and just keep trying */
    if (regs.r_flags & CARRY ) {
	for ( class = 0; class < 2; ++class ) {
	    _pktdevclass = (class) ? PD_SLIP : PD_ETHER;

	    for (pd_type = 1; pd_type < 128; ++pd_type ) {
		regs.r_ax = PD_ACCESS | _pktdevclass;  /* ETH, SLIP */
		regs.r_bx = pd_type;		/* type */
		regs.r_dx = 0;			/* if number */
		regs.r_cx = sizeof( pkt_ip_type );
		regs.r_ds = FP_SEG( &pkt_ip_type );
		regs.r_si = FP_OFF( &pkt_ip_type );
        regs.r_es = FP_SEG( _pktentry);
		regs.r_di = FP_OFF( _pktentry);
		intr( pkt_interrupt, &regs );
		if ( ! (regs.r_flags & CARRY) ) break;
	    }

	    if (pd_type == 128 ) {
		outs("ERROR initializing packet driver\n\r");
		return( 1 );
	    }
	    /* we have found a working type, so kill it */
	    regs.r_bx = regs.r_ax;	/* handle */
	    regs.r_ax = PD_RELEASE;
	    intr( pkt_interrupt, &regs );
	}
    } else {
	pd_type = regs.r_dx;
	switch ( _pktdevclass = (regs.r_cx >> 8)) {
	    case PD_ETHER : _pktipofs = 14;

	    case PD_SLIP  : break;
	    default 	  : outs("ERROR: only ethernet packet drivers allowed\n\r");
			    return( 1 );
	}
    }
    regs.r_ax = PD_ACCESS | _pktdevclass;
    regs.r_bx = 0xffff;  /* any type - was pd_type  type */
    regs.r_dx = 0;			/* if number */
    regs.r_cx = sizeof( pkt_ip_type );
    regs.r_ds = FP_SEG( &pkt_ip_type );
    regs.r_si = FP_OFF( &pkt_ip_type );
    regs.r_es = FP_SEG( _pktentry);
    regs.r_di = FP_OFF( _pktentry);
    memcpy( &regs2, &regs, sizeof( regs ));
    regs2.r_si = FP_OFF( &pkt_arp_type );
    regs2.r_ds = FP_SEG( &pkt_arp_type );

    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) {
	outs("ERROR # 0x");
	outhex( regs.r_dx >> 8 );
	outs(" accessing packet driver\n\r" );
	return( 1 );
    }
    pkt_ip_handle = regs.r_ax;

    if (_pktdevclass != PD_SLIP) {
	intr( pkt_interrupt, &regs2 );
	if ( regs2.r_flags & CARRY ) {
	    regs.r_ax = PD_RELEASE;
	    regs.r_bx = pkt_ip_handle;
	    intr( pkt_interrupt, &regs );

	    outs("ERROR # 0x");
	    outhex( regs2.r_dx >> 8 );
	    outs(" accessing packet driver\n\r" );
	    return( 1 );
	}
	pkt_arp_handle = regs2.r_ax;
    }

    /* get ethernet address */
    regs.r_ax = PD_GET_ADDRESS;
    regs.r_bx = pkt_ip_handle;
    regs.r_es = FP_SEG( eth_addr );
    regs.r_di = FP_OFF( eth_addr );
    regs.r_cx = sizeof( eth_addr );
    intr( pkt_interrupt, &regs );
    if ( regs.r_flags & CARRY ) {
	outs("ERROR # reading ethernet address\n\r" );
	return( 1 );
    }

    return( 0 );
}
pkt_release()
{
    struct REGPACK regs;
    int error;

    error = 0;

    if ( _pktdevclass != PD_SLIP ) {
	regs.r_ax = PD_RELEASE;
	regs.r_bx = pkt_arp_handle;
	intr( pkt_interrupt, &regs );
	if (regs.r_flags & CARRY ) {
	    outs("ERROR releasing packet driver for ARP\n\r");
	    error = 1;
	}
    }

    regs.r_ax = PD_RELEASE;
    regs.r_bx = pkt_ip_handle;
    intr( pkt_interrupt, &regs );
    if (regs.r_flags & CARRY ) {
	outs("ERROR releasing packet driver for IP\n\r");
	error = 1;
    }

    return( error );
}

int pkt_send( char *buffer, int length )
{
    struct REGPACK regs;
    int retries;

    retries = 5;
    while (retries--) {
        regs.r_ax = PD_SEND;
        regs.r_ds = FP_SEG( buffer );
        regs.r_si = FP_OFF( buffer );
        regs.r_cx = length;
        intr( pkt_interrupt, &regs );
        if ( regs.r_flags & CARRY )
            continue;
        return( 0 );
    }
    return( 1 );
}

/* return a buffer to the pool */
pkt_buf_wipe()
{
    memset( pktbuf, 0, sizeof( byte ) * MAXBUFS * (BUFSIZE+ 2));
}
pkt_buf_release( char *ptr )
{
    *(ptr - (2 + 14)) = 0;
}
void * pkt_received()
{
    word i, old;
    word oldin, newin;	/* ip sequence numbers */

    /* check if there are any */
    old = oldin = 0xffff;

    for ( i = 0 ; i < MAXBUFS; ++i ) {
	if ( *pktbuf[i] != 1 ) continue;

    newin = *(word*)(&pktbuf[i][ _pktipofs + 4 + 2]);
	if ( newin <= oldin ) {
	    oldin = newin;
	    old = i;
	}
    }

    return( (old == -1) ? NULL : &pktbuf[old][2] );
#ifdef OLD
    for (i=0; i < MAXBUFS; ++i) {
	if ( *pktbuf[i] == 1 ) {
	    *pktbuf[i] = 2;
	    return( &pktbuf[i][2] );
	}
    }
    return( 0 );
#endif OLD
}

void * _pkt_eth_init()
{
    if ( pkt_init() ) {
	outs("Program halted");
	exit( 1 );
    }
    return( eth_addr );
}
