/* waitsec.cpp
 * This program is public domain.  Do whatever you want with it.  Use at your
 * own risk.
 *
 * The purpose for this program is to wait a specified number of seconds
 * before returning control. It helps in loading programs from the startup.cmd
 * file.  If one program requires another, then you should figure out how long
 * it takes to load the first program, and put a pause for that number of
 * seconds between loading the first and second program.  The only parameter
 * waitsec accepts is a number of seconds.
 *
 * WAITSEC was written and compiled with Borland C++ for OS/2 v1.5.
 * Jeff Lamb, CIS:76256,2123
*/
#define INCL_DOSPROCESS   // Process and thread values
#include <stdio.h>
#include <stdlib.h>
#include <os2.h>

void main(int argc,char *arg[])
{
  if(argc == 2)
  {
    ULONG TI = atoi(arg[1]);
    APIRET  rc;            // Return code

    printf("\nWaiting about %i seconds...",TI);

    rc = DosSleep(TI*1000);

    if (rc != 0)
      printf("DosSleep error: return code = %ld", rc);
  }
  else
    printf("\nYou didn't specify a number of seconds\n");

}; // main()
