#define INCL_DOSPROCESS   // Process and thread values
/* waitfor.cpp
 * This program is public domain.  Do whatever you want with it.  Use at your
 * own risk.
 *
 * The main purpose for this program is to wait for the user to log into the
 * network before attempting to run anything from the network.  WAITFOR.EXE
 * takes two, and only two arguments: 1: The full path name of a file on the
 * network, and 2: The number of seconds between attempts to find the file.
 * The "wait" routine uses DosSleep(), so this is a VERY low priority program.
 * It shouldn't slow down the rest of your system.  Please let me know of any
 * problems, or fix them yourself.
 *
 * WAITFOR was written and compiled with Borland C++ for OS/2 v1.5.
 * Jeff Lamb, CIS:76256,2123
*/

#include <stdio.h>
#include <stdlib.h>
#include <os2.h>

void main(int argc, char* arg[])
{
  if(argc != 3)
    printf("\nWAITFOR fullpathname seconds");
  else
  {
    FILE *fileh;
    ULONG   TimeInterval = atoi(arg[2]);  // Interval in milliseconds
    APIRET  rc;                           // Return code for DosSleep

    printf("\nWaiting for \"%s\" every %i second(s).\n",arg[1],TimeInterval);

    while(! (fileh = fopen(arg[1],"r")))  // Until we see the file
    {
      printf(".");
      rc = DosSleep(TimeInterval*1000);   // Go to sleep
      if (rc != 0)
	printf("DosSleep error: return code = %ld", rc);

    }; // while

    printf("!");
    fclose(fileh);
  }; // if
}; // main()