/* WADEXT.C extract a lump in raw format from a WAD file */
/* Stefan Gustavson 1994 */

#include <stdio.h>


int getshort(filep)
     FILE *filep;
{
  short s;
  s = getc(filep) & 0xff;
  s += (getc(filep) & 0xff)<<8;
  return(s);
}

int getlong(filep)
     FILE *filep;
{
  int l;
  l = getc(filep) & 0xff;
  l += (getc(filep) & 0xff) <<8;
  l += (getc(filep) & 0xff) <<16;
  l += (getc(filep) & 0xff) <<24;
  return(l);
}


main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *wadfile, *rawfile;
  char identifier[4];
  int i, j, numentries, dirstart, entrypos, entrysize;
  char entryname[8];
  
  if (argc != 4)
    {
      fprintf(stderr, "Usage: %s wadfile entryname datafile\n", argv[0]);
      exit(-1);
    }

  rawfile = fopen(argv[3], "w");
  if(rawfile == NULL)
    {
      fprintf(stderr, "Unable to open output file %s.\n", argv[3]);
      exit(-1);
    }
  
  wadfile = fopen(argv[1], "r");
  if(wadfile == NULL)
    {
      fprintf(stderr, "File %s not found.\n", argv[1]);
      exit(-1);
    }
  fread(identifier, 4, 1, wadfile);
  if(strncmp("PWAD", identifier, 4) & strncmp("IWAD", identifier, 4))
    {
      fprintf(stderr, "File %s is not a WAD file.\n", argv[1]);
      exit(-1);
    }
  numentries = getlong(wadfile);
  dirstart = getlong(wadfile);
  if(fseek(wadfile, dirstart, 0))
    {
      fprintf(stderr, "File seek error.\n");
      exit(-1);
    }
 for(i=0; i<numentries; i++)
   {
     entrypos = getlong(wadfile);
     entrysize = getlong(wadfile);
     fread(entryname, 8, 1, wadfile);
     if(!strncmp(entryname, argv[2], 8))
       {
	 printf("Extracting entry %s (%d bytes)... ", entryname, entrysize);
	 fseek(wadfile, entrypos, 0);
	 for(j=0; j<entrysize; j++)
	   putc(getc(wadfile), rawfile);
	 printf("Done.\n");
	 fclose(wadfile);
	 fclose(rawfile);
	 exit(0);
       }
   }
  printf("Entry %s not found!\n", argv[2]);
  fclose(wadfile);
  fclose(rawfile);
}

