import java.io.*;
import java.net.*;
import java.util.*;

/*	Weasel Version 1.01	23rd April 1997

		Author: 	Stephen Summerfield
  		Email: 	s.summerfield@dial.pipex.com
		URL: 		http://ds.dial.pipex.com/s.summerfield/
		
Changes history (dates in European format ;>):

	23/4/1997		Made remote host optional to allow only update of local file.
*/

class Weasel extends FilterInputStream
{
/* Characters used to embed commands in the template file eg ##COMMAND# */
private final byte Include_Start_Marker_Char  = '#';
private final byte Include_End_Marker_Char  = '#';

/* Name of temporary file used to store the results of processing the template file */
static private final String TempFileName = "temp.tmp";

private StringBuffer IncludeBuffer = new StringBuffer();    /* Temporary storage of included text */
private int IncludeBufferIndex = -1;					 						/* Index of current char in above StringBuffer */

/*-----------------------------------------------------------------------
Constructor
-----------------------------------------------------------------------*/
Weasel( InputStream in )
	{
   super( in );
   }

/* The embedded commands */
/*-----------------------------------------------------------------------*/
private StringBuffer ProcessHostname( StringBuffer IncludeBuffer )
	{
	try
 		{
		InetAddress Addr = InetAddress.getLocalHost();
     	IncludeBuffer.append( Addr.getHostName() );
  		}
  	catch( IOException e )
  		{
		System.err.println( "getLocalHost failed" );
  		/* A bit of a hack, but this SHOULD never happen 
   		(except in OS/2, sometimes) */
     	IncludeBuffer.append( "UNKNOWN" );
     	}
 	return( IncludeBuffer );
	}

/*-----------------------------------------------------------------------*/
private StringBuffer ProcessIPAddress( StringBuffer IncludeBuffer )
	{
	try
 		{
		InetAddress Addr = InetAddress.getLocalHost();
     	IncludeBuffer.append( Addr.getHostAddress() );
  		}
  	catch( IOException e )
  		{
  		System.err.println( "getLocalHost failed" );
  		/* A bit of a hack, but this SHOULD never happen 
   		(except in OS/2, sometimes) */
     	IncludeBuffer.append( "?.?.?.?" );
     	}
 	return( IncludeBuffer );
	}

/*-----------------------------------------------------------------------*/
private StringBuffer ProcessTime( StringBuffer IncludeBuffer )
	{
  	IncludeBuffer.append( new Date().toGMTString() );
// 	  	IncludeBuffer.append( new Date().toLocaleString() );
 	return( IncludeBuffer );
	}

/*-----------------------------------------------------------------------
Takes embedded command and processes it
-----------------------------------------------------------------------*/
private StringBuffer ProcessCommand( StringBuffer IncludeCommand )
	{
   IncludeBuffer.setLength(0);
	StringTokenizer st = new StringTokenizer( IncludeCommand.toString(), 
 																					new Character( (char)Include_End_Marker_Char) + " \r\n\t" );

	if( st.hasMoreTokens() )
 		{
      String cmd = st.nextToken();
      if( cmd.equalsIgnoreCase( "HOSTNAME" ) )
      	{
         IncludeBuffer = ProcessHostname( IncludeBuffer );
         }
      if( cmd.equalsIgnoreCase( "IPADDRESS" ) )
      	{
         IncludeBuffer = ProcessIPAddress( IncludeBuffer );
         }
      if( cmd.equalsIgnoreCase( "TIME" ) )
      	{
         IncludeBuffer = ProcessTime( IncludeBuffer );
         }

      /* Add new commands here */

      }

 	return( IncludeBuffer );
  	}

/*-----------------------------------------------------------------------*/
private int ProcessIncludeCommand() throws IOException
	{
	int chr;
 	StringBuffer IncludeCommand = new StringBuffer();

   IncludeCommand.setLength(0);

	/* Read command string */
 	do
  		{
      if( (chr = in.read()) < 0 )
         {	/* End of file, no terminating include marker found */
         IncludeBuffer.setLength(0);
			IncludeBufferIndex = -1;
         return(chr);
         }
      IncludeCommand.append( (char)chr );
      }
   while( chr != Include_End_Marker_Char );

	if( IncludeCommand.length() <= 0 )
 		{	/* Empty command string, return marker character (like an escape sequence) */
      return( Include_Start_Marker_Char );
      }

 	/* Now actually process include command string */
 	ProcessCommand( IncludeCommand ); 

   if( IncludeBuffer.length() <= 0 )
      {	/* Empty include command, return a marker character */
      IncludeBuffer.setLength(0);
		IncludeBufferIndex = -1;
  		return( Include_Start_Marker_Char );
      }
	IncludeBufferIndex = 1;

	return( IncludeBuffer.charAt(0) );
   }

/*-----------------------------------------------------------------------*/
/* Gets next character of data, if the include marker character is found the include command text 
is replaced by the appropriate replacement text
*/
public int read() throws IOException
   {                                                                        
   int chr=-1;

	if( IncludeBufferIndex >= 0 )
 		{	/* Read char from the include buffer */
      chr = IncludeBuffer. charAt(IncludeBufferIndex);
  		if( ++IncludeBufferIndex >= IncludeBuffer.length() )
    		{
		   IncludeBufferIndex = -1;
         }
     	}
   else
      {	/* Read char from the input stream */
	   if( (chr = in.read()) == Include_Start_Marker_Char )
         {	/* Read next char */
   		int chr2;

     	   if( (chr2 = in.read()) == Include_Start_Marker_Char )
				{        /* Two consecutive marker chars means an include follows */
          	/* Process include command */
            chr = ProcessIncludeCommand();	/* Return first char of include */
           	}
         else
            {  /* Single marker char found, not an include, push back last read char */
				((PushbackInputStream) in).unread(chr2);
            } 
         }
      }

   return( chr );
   }

/*-----------------------------------------------------------------------*/
public static void process( InputStream istream, OutputStream ostream  ) throws IOException
 	{
        // Read stream
        Weasel in = new Weasel( new PushbackInputStream( istream ) );

		  int chr;
        while( true )
		 	  {
           if( (chr = in.read())  < 0 )
              {
              break;
              }
	        ostream.write( chr );
        	  }
    }
    
/*-----------------------------------------------------------------------*/
//public static void main(String[] args) throws MalformedURLException, IOException
public static void main(String[] args) throws IOException
   {
   String HFName = null;
   String HDir = null;

	if( args.length < 1 )
 		{
      System.out.println();
      System.out.println( "Too few parameters" );
      System.out.println();
      System.out.println( "Usage: " );
      System.out.println( "   src_filespec [ftphostname username password] [remotedirspec] [remotefilename] " );
      System.out.println();
      System.exit(-1);
     	}

	if(  args.length == 1 )
		{		/* Give warning that patched file will remain on local drive */
      System.out.println( "No remote host specified, no upload attempted." );
     	}
     	
	if( args.length > 4 )
 		{                     	/* Optional parameters */
      HDir = args[4];
		if( args.length > 5 )
 			{
  	    	HFName = args[5];
   	   }
		else
 			{		/* Strip the filename out of the template's file path and use that for the remote file name */
			HFName =  (new File( args[0] )).getName();
   	   }
       }

	FileInputStream InStream= new FileInputStream( args[0] );

	File TempFile = new File( TempFileName );
 	TempFile.delete();
	FileOutputStream OutStream= new FileOutputStream( TempFileName );

	process( InStream, OutStream );

	if(  args.length > 1 )
		{ 	/* Only attempt upload if host, etc has been specified */
	 	SendFileByftpSun trans = new SendFileByftpSun( TempFileName, args[1], args[2], args[3], HDir, HFName );
	 	}

//	TempFile = new File( TempFileName );
// 	TempFile.delete();		/* Leave temporary file after processing. */
   }

/*-----------------------------------------------------------------------*/
/* End of class */
}
/*-----------------------------------------------------------------------*/

