/* Borland C++:
 *  bcc32 -tWM -w redirect.c
 * Visual C++:
 *  cl /MT redirect.c user32.lib advapi32.lib
 */

#define STRICT
#include <windows.h>
#include <process.h>
#include <stdio.h>
#include <conio.h>

typedef struct
{
  HANDLE hReadPipe;
  FILE *fh;
}
Parameters,*PParameters;

BOOL IsWindowsNT(void)
{
  OSVERSIONINFO osv;

  osv.dwOSVersionInfoSize = sizeof(osv);
  GetVersionEx(&osv);
  return (osv.dwPlatformId == VER_PLATFORM_WIN32_NT);
}

void RedirectThread(LPVOID lpvThreadParam)
{
  BOOL fStatus;
  char szBuffer[1];
  DWORD dwBytesRead;
  PParameters param = (PParameters)lpvThreadParam;

  while (TRUE)
  {
    fStatus = ReadFile(
      param->hReadPipe,
      szBuffer,
      sizeof(szBuffer),
      &dwBytesRead,
      NULL
      );
    if (fStatus == TRUE)
    {
      szBuffer[dwBytesRead] = '\0';
      fprintf(param->fh,"%s",szBuffer);
    }
    else
    {
      _endthread();
    }
  }
}

void main(int argc,char *argv[])
{
  BOOL fStatus;
  HANDLE hThread;
  STARTUPINFO si;
  Parameters param;
  HANDLE hWritePipe;
  char szBuffer[100];
  PROCESS_INFORMATION pi;
  SECURITY_ATTRIBUTES sa;
  SECURITY_DESCRIPTOR sd;
  LPSECURITY_ATTRIBUTES lpsa = NULL;

  if (argc < 3 || argc > 3)
  {
    printf("redirect [file name] [command]\n");
    return;
  }
  if ((param.fh = fopen(argv[1],"w+t")) == NULL)
  {
    printf("Failed to create file: %s\n",argv[1]);
    return;
  }
  if (IsWindowsNT() == TRUE)
  {
    // Create a security descriptor allowing inheritence of handles
    InitializeSecurityDescriptor(&sd,SECURITY_DESCRIPTOR_REVISION);
    SetSecurityDescriptorDacl(&sd,TRUE,NULL,FALSE);
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = &sd;
    lpsa = &sa;
  }
  CreatePipe(&param.hReadPipe,&hWritePipe,lpsa,1);
  hThread = (HANDLE)_beginthread(
    RedirectThread,
    0,
    &param
    );
  CloseHandle(hThread);
  if (IsWindowsNT() == TRUE)
  {
    wsprintf(szBuffer,"cmd /c %s",argv[2]);
  }
  else
  {
    wsprintf(szBuffer,"command.com /c %s",argv[2]);
  }
  ZeroMemory(&si,sizeof(STARTUPINFO));
  si.cb = sizeof(STARTUPINFO);
  si.dwFlags = STARTF_USESTDHANDLES;
  si.hStdOutput = hWritePipe;
  si.hStdError = hWritePipe;

  fStatus = CreateProcess(
    NULL,
    szBuffer,
    NULL,
    NULL,
    TRUE,
    DETACHED_PROCESS, // No console window
    NULL,
    NULL,
    &si,
    &pi
    );
  CloseHandle(pi.hThread);
  if (fStatus == FALSE)
  {
    printf("Failed to create process: %d\n",GetLastError());
    return;
  }
  WaitForSingleObject(pi.hProcess,INFINITE);
  CloseHandle(hWritePipe);
  CloseHandle(param.hReadPipe);
  CloseHandle(pi.hProcess);
  fclose(param.fh);
  return;
}
