/* Borland C++:
 *  bcc32 -W -w pipeclip.c
 * Visual C++:
 *  cl pipeclip.c user32.lib
 */

#include <stdlib.h>
#include <windows.h>

/* maximum size of data we move to clipboard */
#define MAXDATALEN  (65536)

static char ErrorMsg[256];
#define COMPLAIN(s) wsprintf(ErrorMsg, \
    "[%d]: %s", GetLastError(), s), \
    MessageBox(NULL, ErrorMsg, "pipeclip.exe", MB_OK)

int ToClip(const char* Buffer, DWORD Size)
    {
    int     Result = FALSE;     /* assume failure */
    if(OpenClipboard(NULL))
        {
        if(EmptyClipboard())
            {
            HGLOBAL ClipData = GlobalAlloc(
                GMEM_MOVEABLE|GMEM_DDESHARE, Size);
            if(ClipData)
                {
                void*   P = (void*)GlobalLock(ClipData);
                memcpy(P, Buffer, Size);
                GlobalUnlock(ClipData);
                if(SetClipboardData(CF_TEXT, ClipData))
                    Result  = TRUE; /* finally, success! */
                CloseClipboard();
                }
            else
                COMPLAIN("Insufficient memory for clipboard!");
            }
        else
            COMPLAIN("Could not empty clipboard!");
        }
    else
        COMPLAIN("Could not open clipboard!");
    return Result;
    }


#if defined(__BORLANDC__)
    #pragma argsused
#endif
int WINAPI WinMain(HINSTANCE Instance, HINSTANCE Previous,
        LPSTR CommandLine, int ShowCommand)
    {
    int     Result = FALSE; /* assume failure */
    DWORD   NRead=0;
    char   *Buffer;
    HANDLE  StdIn    = GetStdHandle(STD_INPUT_HANDLE);
    if(StdIn != INVALID_HANDLE_VALUE)
        {
        Buffer  = (char*)malloc(MAXDATALEN);
        if(Buffer != 0)
            {
            if(ReadFile(StdIn, Buffer, MAXDATALEN, &NRead, 0))
                {
                if(NRead > 0 && ToClip(Buffer, NRead))
                    Result  = TRUE; /* finally, success! */
                }
            else
                COMPLAIN("ReadFile failed!");
            }
        else
            COMPLAIN("Insufficient memory!");
        }
    else
        {
        MessageBox(NULL, "Usage: <command> | pipeclip.exe\n"
            "To pipe data into the Windows clipboard.",
            "pipeclip.exe", MB_OK);
        }

    return Result;
    }

