'
' WDJ Search Applet
'
Option Explicit


Sub BrowseFile_Click ()
'
' Select file to search
'

CDialog.Flags = OFN_FILEMUSTEXIST Or OFN_HIDEREADONLY
CDialog.DialogTitle = "Select File to Search"
CDialog.Filter = "All Files|*.*|Text Files (*.txt)|*.txt" + _
    "|C Files (*.c, *.h)|*.c;*.h"
CDialog.MaxFileSize = 300

CDialog.Filename = ""       ' Make sure filename starts blank.

On Error Resume Next
CDialog.Action = 1
On Error GoTo 0

If CDialog.Filename <> "" Then
    SrchFileName.Text = CDialog.Filename
    End If

End Sub

Sub CloseApp_Click ()
'
' Done
'

End

End Sub

Sub Form_Load ()
'
' Set up the Message Blaster
'

MsgBlast.hWndTarget = WDJSearch.hWnd ' Point Blaster at this form

MsgBlast.MsgList(0) = WM_USER + 1   ' Private "Progress" message
MsgBlast.MsgPassage(0) = MBLST_EAT  ' Absorb message

MsgBlast.MsgList(1) = WM_USER + 2   ' Private "Found" message
MsgBlast.MsgPassage(1) = MBLST_EAT  ' Absorb message

End Sub

Sub MsgBlast_Message (MsgVal As Integer, wParam As Integer, _
    lParam As Long, ReturnVal As Long)
'
' Handle messages sent from DLL
'

Select Case MsgVal

    Case WM_USER + 1        ' Progress message
        ProgBar.Value = wParam  ' Percent-done is wParam
        ProgPercent.Caption = wParam & "%"

    Case WM_USER + 2        ' "Found" message
        FoundList.AddItem Format$(lParam)   ' Line found is lParam
        FoundCount.Caption = Str$(FoundList.ListCount)

    End Select

DoEvents            ' Update UI

End Sub

Sub SearchCancel_Click ()
'
' Cancel this search
'

SrchCancel

End Sub

Sub SearchStart_Click ()
'
' Start the search
'
Dim rc As Integer

FoundList.Clear     ' Nothing in found list

SearchCancel.Enabled = True     ' Turn on "Cancel" button

If SrchFile(WDJSearch.hWnd, SrchFileName.Text, _
   SrchText.Text) = False Then
    MsgBox "Search function failed!", MB_ICONEXCLAMATION, _
        "WDJ Search"
    End If

SearchCancel.Enabled = False    ' Turn off "Cancel" button

ProgBar.Value = 0
ProgPercent.Caption = "%"

End Sub

