//
// WDJ Search Example
//
#include "windows.h"
#include "stdio.h"
#include "io.h"
#include "string.h"

static volatile char s_cancel;		// Cancel the current search
                                             
#define VBTRUE	(-1)		// VB uses -1 and 0
#define VBFALSE	(0) 

#define MAXLINE	256			// Maximum line/search size
#define INFINT  200			// Send prog. info every INFINT lines

#define EXPORT	_export _far _pascal

//
// Private message definitions
#define PM_PROG (WM_USER + 1)	// Progress Report
#define PM_FND	(WM_USER + 2)	// Text Found

//
// Search a file for a text
//
// Returns TRUE for success, false for error.
//

short EXPORT SrchFile(
HWND owner,					// Window to get messages
const char *filename,		// File to search
const char *srchtext)		// Text to search for
{
	FILE *sf;				// File we're searching
	char stext[MAXLINE];	// UC version of search text
	char inbuf[MAXLINE];	// Input line
	long lct = 0;			// Line counter
	long flen;				// File size
	
if ((sf = fopen(filename, "r")) == NULL)
	return(VBFALSE);
	
flen = _filelength(_fileno(sf));	// Read the file size
	
strcpy(stext, srchtext);
strupr(stext);

s_cancel = 0;					// Start with cancel off

while (!s_cancel && fgets(inbuf, sizeof(inbuf), sf) != NULL) {
	
	if (lct++ % INFINT == 0) {		// Snd prog. every INFINT
		SendMessage(owner, PM_PROG, // Progress is sent as WPARAM
			(WPARAM) (ftell(sf) * 100L / flen), 0);
		Yield();					// Yield to other Win3x apps
		}
		
	if (strstr(strupr(inbuf), stext) != NULL) 	// Text found
		SendMessage(owner, PM_FND,
			0, lct);				// Send "found" line as LPARAM

	}
	
fclose(sf);
 
return(VBTRUE); 
}



//
// Cancel function
//
// Sets the cancel flag when called
//

void EXPORT SrchCancel(void)
{

s_cancel = 1;

}
