#ifndef _PEIMAGE_H
#define _PEIMAGE_H

/*//////////////////////////////////////////////////////////////////
                            Special Includes
//////////////////////////////////////////////////////////////////*/
#include <imagehlp.h>

/*//////////////////////////////////////////////////////////////////
                          Special Enumerations
//////////////////////////////////////////////////////////////////*/
// These are the error enumerations that are are returned by
//  various member functions of CPEImage.
typedef enum _PEI_ERROR
{
    // Everything is good.
    PEI_NOERROR     ,
    // Bad parameters were passed.
    PEI_BADPARAMS   ,
    // The class is already initialized with an image.  Call
    //  UnloadImage to unload the existing image to use this
    //  instance of the class again.
    PEI_ALREADYINIT ,
    // The class has not been initialized.  Call LoadImage to
    //  initialize it.
    PEI_NOTINIT     ,
    // The image could not be mapped.  Either it did not exist,
    //  or it is not a WIN32 PE image.
    PEI_NOTMAPPED   ,
} PEI_ERROR ;

/*//////////////////////////////////////////////////////////////////
                       CPEImage Class Definition
//////////////////////////////////////////////////////////////////*/
class CPEImage
{
/*//////////////////////////////////////////////////////////////////
                  Public Constructors and Destructors
//////////////////////////////////////////////////////////////////*/
public      :
    // Initializes the entire class.  Call LoadImage to do the
    //  real load.
    CPEImage ( void ) ;

    // The usual destructor.  It will unload the image if needed.
    ~CPEImage ( void ) ;

/*//////////////////////////////////////////////////////////////////
           Public Initialization and Cleanup Member Functions
//////////////////////////////////////////////////////////////////*/
public      :
    // Loads the PE image specified in szFile (which must contain
    //  the complete filename to load).
    PEI_ERROR LoadImage ( LPCTSTR szFile ) ;

    // Does the opposite of LoadImage.
    void UnloadImage ( void ) ;

/*//////////////////////////////////////////////////////////////////
                        Public Helper Functions
//////////////////////////////////////////////////////////////////*/
public      :
    // Converts an RVA into a pointer to the actual data.
    LPCVOID ImageRvaToFileVa ( DWORD dwRVA ) const ;

/*//////////////////////////////////////////////////////////////////
                 Public PE Header Information Functions
//////////////////////////////////////////////////////////////////*/
public      :
    // Returns the PE headers.
    const PIMAGE_NT_HEADERS GetImageHeaders ( void ) const ;

    // Returns the requested section header.
    const PIMAGE_SECTION_HEADER
                       GetSectionHeader ( int iSection ) const ;

    // Gets the particular data directory data.
    DWORD GetDataDirectoryRVA ( int iDataDir ) const ;

/*//////////////////////////////////////////////////////////////
                  Protected Class Data Members
//////////////////////////////////////////////////////////////*/
protected   :
    // Internally, we use the IMAGEHLP functions to do the
    //  grungy work for us.  This is the structure that is
    //  returned by the MapAndLoad API call.
    LOADED_IMAGE    m_stLoadedImage ;
} ;

#endif      // _PEIMAGE_H


