/*//////////////////////////////////////////////////////////////////
                       The Main Includes
//////////////////////////////////////////////////////////////////*/
// Why won't the windows header compile with warning level 4?
#pragma warning ( disable : 4201 )
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <imagehlp.h>
#include <stdlib.h>
#include <tchar.h>
#include <direct.h>
#include "PEImage.h"

/*//////////////////////////////////////////////////////////////////
                  Public constructors and destructors.
//////////////////////////////////////////////////////////////////*/
CPEImage :: CPEImage ( void )
{
    // Initialize all class members to a known state.
    memset ( &m_stLoadedImage , NULL , sizeof ( LOADED_IMAGE ) ) ;
}

CPEImage :: ~CPEImage ( void )
{
    // Unload if necessary.
    UnloadImage ( ) ;
}

/*//////////////////////////////////////////////////////////////////
           Public Initialization and Cleanup Member Functions
//////////////////////////////////////////////////////////////////*/
PEI_ERROR CPEImage :: LoadImage ( LPCTSTR szFile )
{
    if ( NULL == szFile )
    {
        return ( PEI_BADPARAMS ) ;
    }

    if ( NULL != m_stLoadedImage.ModuleName )
    {
        return ( PEI_ALREADYINIT ) ;
    }

    // OK, the MapAndLoad API searches all over the path for a
    //  file to load.  I want mine to be concentrate on just
    //  the file passed in, therefore, I make sure that there
    //  is some sort of path characters in the string, such
    //  as ".." or "\".  If there is none, then I will just
    //  build the filename with the complete current directory.
    // A temporary buffer where we stick the filename.
    TCHAR szRealFileName [ MAX_PATH ] ;
    _tcscpy ( szRealFileName , szFile ) ;
    if ( NULL == _tcspbrk ( szRealFileName , _T ( "\\" ) ) )
    {
        // The file is just a filename.  Put the current
        //  directory on it.
        _tgetcwd ( szRealFileName , sizeof ( szRealFileName ) ) ;
        _tcscat ( szRealFileName , _T ( "\\" ) ) ;
        _tcscat ( szRealFileName , szFile ) ;
    }

    // Now we are ready to load up the image.
    BOOL bRet = ::MapAndLoad ( szRealFileName   ,
                               NULL             ,
                               &m_stLoadedImage ,
                               TRUE             ,
                               TRUE              ) ;
    // Skip out now if we need to.
    if ( FALSE == bRet )
    {
        return ( PEI_NOTMAPPED ) ;
    }
    return ( PEI_NOERROR ) ;
}

void CPEImage :: UnloadImage ( void )
{
    // Is there anything that we need to unload?
    if ( NULL != m_stLoadedImage.ModuleName )
    {
        ::UnMapAndLoad ( &m_stLoadedImage ) ;
        // Reinitialize the main structure so this class instance
        //  could be used again.
        memset ( &m_stLoadedImage , NULL , sizeof ( LOADED_IMAGE));
    }
}

const PIMAGE_SECTION_HEADER CPEImage
                         :: GetSectionHeader ( int iSection ) const
{
    if ( iSection >= m_stLoadedImage.FileHeader->
                                      FileHeader.NumberOfSections )
    {
        return ( NULL ) ;
    }

    return ( &m_stLoadedImage.LastRvaSection[ iSection ] ) ;
}

DWORD CPEImage :: GetDataDirectoryRVA ( int iDataDir ) const
{
    if ( iDataDir >= IMAGE_NUMBEROF_DIRECTORY_ENTRIES )
    {
        return ( (DWORD)-1 ) ;
    }
    return ( m_stLoadedImage.FileHeader->
           OptionalHeader.DataDirectory[ iDataDir ].VirtualAddress);
}


LPCVOID CPEImage :: ImageRvaToFileVa ( DWORD dwRVA ) const
{
    return ((LPCVOID)::ImageRvaToVa( m_stLoadedImage.FileHeader    ,
                                     m_stLoadedImage.MappedAddress ,
                                     dwRVA                         ,
                                     NULL                        ));
}

const PIMAGE_NT_HEADERS CPEImage :: GetImageHeaders ( void ) const
{
    return ( m_stLoadedImage.FileHeader ) ;
}

