#include <afxwin.h>
#include <afxext.h>
#include "listdlg.h"

BEGIN_MESSAGE_MAP(CListDialog, CDialog)
   ON_BN_CLICKED(IDC_ADD, OnAdd)
   ON_BN_CLICKED(IDC_INS, OnIns)
   ON_BN_CLICKED(IDC_DEL, OnDel)
   ON_BN_CLICKED(IDC_RESET, OnReset)
   ON_BN_CLICKED(IDC_EXIT, OnExit)
END_MESSAGE_MAP()


CListDialog::CListDialog(CWnd* pParent)
   : CDialog(IDD_LISTDIALOG, pParent), m_ctrlList(HLS_NOSCROLL)
{
   m_strName = "";
}

void CListDialog::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   
   DDX_Control(pDX, IDC_LISTBOX, m_ctrlList);
   DDX_Text(pDX, IDC_EDIT, m_strName);
}


void CListDialog::OnAdd()
{
   UpdateData(TRUE);
   
   m_ctrlList.AddString(m_strName);
}

void CListDialog::OnIns()
{
   UpdateData(TRUE);

   int nSel = m_ctrlList.GetCurSel();
   if(nSel >= 0)
      m_ctrlList.InsertString(nSel, m_strName);
   else
      MessageBox("Select a Position", "Insert Message", MB_OK);
}

void CListDialog::OnDel()
{                      
   UpdateData(TRUE);           
   
   int nSel = m_ctrlList.GetCurSel();
   if(nSel >= 0)
      m_ctrlList.DeleteString(nSel);
   else
      MessageBox("Select Item to Delete",
         "Delete Message", MB_OK);
}

void CListDialog::OnReset()
{                  
   UpdateData(TRUE);
   
   m_ctrlList.ResetContent();
}

void CListDialog::OnExit()
{                  
   EndDialog(FALSE);
}
