#ifndef _HLISTBOX_H_
#define _HLISTBOX_H_

#include <afxwin.h>
#include <afxext.h>

#define CHUNK_SIZE 256   


#define HLS_SCROLL   0
#define HLS_NOSCROLL 1  

// ************ begin sorted extent class
#include <string.h>

//Sorted int container
class SortedExtent
{  
   int *pn; 
   int nSize;
   int nCount;
public:
   SortedExtent(){pn = new int[CHUNK_SIZE];
      nSize = CHUNK_SIZE; nCount = 0;}
   ~SortedExtent(){delete []pn;}
   
   BOOL Add(int anInt);
   BOOL Remove(int anInt);
   
   int GetMax(){return nCount?pn[0]:0;} //If empty 0 is max
   void Reset(){delete[]pn; pn = new int[CHUNK_SIZE];
      nSize = CHUNK_SIZE; nCount = 0;}
};

// ************ end sorted extent class


//Horz Scroll List Box
class CHListBox : public CListBox
{
   SortedExtent se;
   int nXStyle;
   int GetTextWidth( LPCSTR lpszItem );
   void Reposition(int nMax, int nNewMax);
public:
   CHListBox(int anInt=HLS_SCROLL):CListBox(), nXStyle(anInt){}
   int AddString( LPCSTR lpszItem );
   int DeleteString( UINT nIndex ); 
   int InsertString( int nIndex, LPCSTR lpszItem );
   void ResetContent( void );
};                 

#endif
