#include <afxwin.h>
#include <afxext.h>
#include "hlistbox.h"



//Adds an extent to the sorted container.
BOOL SortedExtent::Add(int anInt)
{  
   if(nCount >= nSize)
   {
      //Container full so grow it.
      int *p = new int[nSize + CHUNK_SIZE];
      memcpy(p, pn, sizeof(int)*nCount);
      delete []pn;
      pn = p;
      nSize += CHUNK_SIZE;
   }
   //Locate the position to insert
   int i, j;
   for(i = 0; i < nCount; i++)
      if(anInt > pn[i])
         break;
   
   //Move the rest down
   for(j = nCount-1; j >= i; j--)
      pn[j+1] = pn[j];
   
   //Insert
   pn[i] = anInt;
   
   nCount++;
   
   return TRUE;
}

//Removes an extent from the sorted container.
BOOL SortedExtent::Remove(int anInt)
{
   //locate the position to remove
   int i, j;
   for(i = 0; i < nCount; i++)
      if(anInt == pn[i])
         break;
         
   if(i == nCount)
      return FALSE;

   //move the rest up
   for(j = i; j < nCount-1; j++)
      pn[j] = pn[j+1];
      
   nCount--;
   
   if((nCount + CHUNK_SIZE) < nSize)
   {
      //More than CHUNK_SIZE of space unused so shrink it
      int *p = new int[nSize-CHUNK_SIZE];
      memcpy(p, pn, sizeof(int)*nCount);
      delete []pn;
      pn = p;
   }        
   
   return TRUE;
}     



//Return the width of text in pixels.
int CHListBox::GetTextWidth( LPCSTR lpszItem)
{
   TEXTMETRIC tm;
   CDC *pDC = GetDC();
   CFont *pFont = pDC->SelectObject(GetFont());
   CSize sz = pDC->GetTextExtent(lpszItem, lstrlen(lpszItem));
   
   pDC->GetTextMetrics(&tm);
  
   pFont = pDC->SelectObject(pFont);
   ReleaseDC(pDC);
   
   //To avoid clipping of some pixels add a little extra.
   return sz.cx+tm.tmAveCharWidth;
}

//Add a string to list box.
int CHListBox::AddString( LPCSTR lpszItem )
{
   //Perform original
   int nRetVal = CListBox::AddString(lpszItem);
   
   //On success manipulate horz extent
   if(nRetVal >= 0)
   {
      int nMax = se.GetMax();
      
      se.Add(GetTextWidth(lpszItem));
      if(se.GetMax() > nMax)
         SetHorizontalExtent(se.GetMax());
   }
   return nRetVal;
}

//Delete a string from list box.
int CHListBox::DeleteString( UINT nIndex )
{
   CString str;
   GetText(nIndex, str);

   //Perform original
   int nRetVal = CListBox::DeleteString(nIndex);

   //On success manipulate horz extent
   if(nRetVal >= 0)
   {           
      int nMax = se.GetMax();
      
      se.Remove(GetTextWidth(str));
      if(se.GetMax() < nMax)
      {
         SetHorizontalExtent(se.GetMax());
         Reposition(nMax, se.GetMax());
      }
   }
   return nRetVal;
} 

//Insert a string to list box at specified index.
int CHListBox::InsertString( int nIndex, LPCSTR lpszItem )
{
   //Perform original
   int nRetVal = CListBox::InsertString(nIndex, lpszItem);
   
   //On success manipulate horz extent
   if(nRetVal >= 0)
   {
      int nMax = se.GetMax();
      
      se.Add(GetTextWidth(lpszItem));
      if(se.GetMax() > nMax)
         SetHorizontalExtent(se.GetMax());
   }
   
   return nRetVal;
}

//Reset contents of list box.
void CHListBox::ResetContent( void )
{
   CListBox::ResetContent();//Perform orignal
           
   //Manipulate the scroll extent.
   se.Reset();
   SetHorizontalExtent(0);
}

//Reposition the list box
void CHListBox::Reposition(int nMax, int nNewMax)
{
   if(nXStyle == HLS_NOSCROLL)
   {
      int nMinPos, nMaxPos, nRange, nPos; //Scroll Bar info
      int nLBWidth;     //List Box client width    
      int nPix;         //No of pixels scrolled
      CRect rect;       //Client rect of listbox
                                                      
      GetScrollRange(SB_HORZ, &nMinPos, &nMaxPos);
      
      //If nMaxPos is 0 then no scroll bar so no need to check.
      if(nMaxPos)
      {          
         nRange = nMaxPos - nMinPos;
         nPos = GetScrollPos(SB_HORZ) - nMinPos;
            
         GetClientRect(&rect);
         nLBWidth = rect.Width();
            
         nPix = (nMax - nLBWidth) * nPos / nRange;
            
         if(nNewMax < (nPix + nLBWidth)) //Invalid area?
         {
            SetHorizontalExtent(nNewMax);
            SendMessage(WM_HSCROLL, SB_RIGHT,
               MAKELONG(0, this->m_hWnd));
         }
      }
   }
   else
      SendMessage(WM_HSCROLL, SB_LEFT,
         MAKELONG(0, this->m_hWnd));
}

