//
// APR97.CPP
//
// Microsoft made major changes to their implementation
// of the C++ standard library in their 4.2 release.
// Unfortunately, some of the changes appear to have
// broken existing classes.  For example, including the
// vector header file in this program causes an attempt
// to perform comparisons of CString objects to fail.
//
// In this particular example, I compile the program
// from the command line using the following command:
//
//  CL /GX apr97.cpp mfc42.lib
//
// The compile fails with an error C2373, saying that
// '!=" has been redefined with different type modifiers
// Changing the arguments to foo() to be const fixes
// the problem, as does removing the include of vector.
//
#include <afx.h>
#include <iostream>
#include <vector>

void foo( CString &s1, CString &s2 )
{
    if ( s1 != s2 )
        cout << "Mismatch\n";
}

main()
{
    CString a = "a";
    CString b = "b";
    foo( a, b );
    foo( a, a );
    return 1;
}
