// STATPROX.h - include file for VxD STATPROX

#include <vtoolscp.h>

#define DEVICE_CLASS        StatproxDevice
#define STATPROX_DeviceID   UNDEFINED_DEVICE_ID
#define STATPROX_Init_Order UNDEFINED_INIT_ORDER
#define STATPROX_Major      1
#define STATPROX_Minor      0

#include    <statdioc.h>
#include    "classes.h"

class StatproxDevice : public VDevice
{
protected:
    CPerfHeap*      m_pPerfHeap; 
    int             m_Usage;

    CStatServer*    GetServerNode(const char* szServer);
    STATHANDLE      AddStat(CStatServer* pServer, const char* szName, const char* szDesc, BOOL bValueNotRate, int* index);
    void            RemoveStat(CStatServer* pServer, const STATHANDLE hStat, const int index);

public:
    virtual BOOL OnSysDynamicDeviceInit();
    virtual BOOL OnSysDynamicDeviceExit();
    virtual BOOL OnDeviceInit(VMHANDLE hSysVM, PCHAR pszCmdTail);
    virtual DWORD OnW32DeviceIoControl(PIOCTLPARAMS pDIOCParams);
};

