// Classes.h    --  Class definitions for WHSPERFS.VXD
// =========

#ifndef _CLASSES_H
#define _CLASSES_H

#include    <vtoolscp.h>        // VtoolsD

///////////////////////////////////////////////////////////////////
// CStatServer   Class describing stats "server" node. Each server
// ===========   object corresponds to an app (module)  in Ring3
//                API terms. The servers are linked into a list.
class CStatServer
{
protected:
    // pointer to a list for node allocation
   static VList* sm_pList;  
   
   // per-instance data
   DWORD            m_Signature;
   int              m_RefCount;         // # of created stats 
   PERFHANDLE       m_hPerfMonServer;   // PERF server
   char m_szName[MAXNAMELEN];           // MAXNAMELEN (see perf.h)

   // common statics
   static char sm_szNamePreffix[MAXNAMELEN];
   const DWORD cm_Signature;

public:
   CStatServer(const char *szName);
   virtual ~CStatServer();

   void* _cdecl operator new(size_t n)    // override "new"
      {return sm_pList->newNode();};
   void  _cdecl operator delete(void* p) // override "delete"
      {sm_pList->deleteNode(p);};

    // list of modules functionality
    static void  CreateList();
    static void  DestroyList();
    static CStatServer* First() 
            { return (CStatServer* )sm_pList->first(); }
    static CStatServer* Next(CStatServer* pM) 
            { return (CStatServer* )sm_pList->next((PNODE)pM); }

    // per-instance methods
    void     Append() { sm_pList->attachTail((PNODE)this); }
    BOOL     Remove() {return sm_pList->remove((PNODE)this); }

    // Stats node methods
    STATHANDLE AddStat(const char* szName, 
            const char* szDesc,  DWORD* where, BOOL bValueNotRate);
    void RemoveStat(STATHANDLE hStat);

    // verifyiers & helpers
    BOOL IsGood() { return m_Signature==cm_Signature; }
    BOOL IsReferenced() { return m_RefCount>0; }
    const char* Name() { return m_szName; }
};


///////////////////////////////////////////////////////////////////
// CPerfHeap -- Manager of a shared area, where the monitored stat
// =========    -dwords are allocated from. Ring 3 is supposed to 
//              provide a memory blocked allocated in the shared
//              address space (memory-mapped-file).
class CPerfHeap {
protected:
    #define MAXITEMS  1024       // elems (DWORDS) in heap
    DWORD*      m_pArea;        // where is the area
    DWORD       m_size;         // size (ext to 1 page)
    DWORD       m_Bitmap[MAXITEMS]; // page usage bitmap
public:
    CPerfHeap(DWORD* pArea, DWORD size=MAXITEMS);   
    virtual ~CPerfHeap();

    // methods
    int         Allocate();         // returns an index in the area
    void        Free(int index);    // frees the dword
    // helper
    DWORD*      GetAddr(int index) const
                { return (index>=0) ? m_pArea+index : NULL; }
};

#endif // _CLASSES_H
