// Classes.cpp  --  class implementations for STATPROX

#include    "classes.h"

#include    <Vsvctab.h>

// common prefix for app's statistics:
char CStatServer::sm_szNamePreffix[MAXNAMELEN] = "App::"; 
VList* CStatServer::sm_pList=NULL;  

//  Constructor: registers a stats "server"
CStatServer::CStatServer(const char *szName) :
    cm_Signature(0xAAAABBBB), m_RefCount(0)
{
     m_Signature = cm_Signature; 
    char szShowName[128];
    strcat(strcpy(szShowName, sm_szNamePreffix), 
               strncpy(m_szName, szName, sizeof(m_szName)-1));

    PERF_SERVER_0   PerfMonServer;
    PerfMonServer.psrv0_Level           = 0L;
    PerfMonServer.psrv0_Flags           = PSTF_RATE; //0? 
    PerfMonServer.psrv0_pszServerName   = szShowName; // @ SYSMON
    PerfMonServer.psrv0_pszServerNodeName   = szShowName; 
    PerfMonServer.psrv0_pControlFunc        = NULL; 

    m_hPerfMonServer = ::PERF_Server_Register (&PerfMonServer);
}

// Destructor: deregister a stats server
CStatServer::~CStatServer()                                    
{
    // NOTE: PERF.VxD doesn't remove stats even if their server 
    // ===== has gone (weird) => BAD => the DLL should keep
    //       track and release malicious stats.
    if (m_hPerfMonServer)
        ::PERF_Server_Deregister (m_hPerfMonServer);
}

// Creates the List: should be called first & once:
void CStatServer::CreateList()
{ 
   sm_pList = new VList(sizeof(CStatServer)); 
}

// Destroys the list: should be called last:
void CStatServer::DestroyList()
{
    // remove each server and destroy its node list
    CStatServer* snode;
    while ((snode=CStatServer::First())!=NULL) {
        snode->Remove();
        delete snode;
    };
    delete sm_pList;
    sm_pList=NULL;
}

// Adding/Removing stats
STATHANDLE CStatServer::AddStat(const char* szName, 
    const char* szDescription,  DWORD* where, BOOL bValueNotRate)
{
    PERF_STAT_0     Stat;
    STATHANDLE      hStat=NULL;

    Stat.pst0_Flags = (bValueNotRate) ? PSTF_COUNT : PSTF_RATE;
    Stat.pst0_Level = 0L;
    Stat.pst0_pszStatNodeName = (char*)szName;  
    Stat.pst0_reserved      = NULL;
    Stat.pst0_ScaleFactor   = 0L;
    Stat.pst0_pszStatName   = (char*)szName;    
    Stat.pst0_pszStatDescription = (char*)szDescription;
    Stat.pst0_pStatFunc         = (void *)where;
    
    if (m_hPerfMonServer) {
        hStat = ::PERF_Server_Add_Stat (m_hPerfMonServer, &Stat);
        if (hStat)
            {m_RefCount++; }
        }

    return hStat;
}

void CStatServer::RemoveStat(STATHANDLE hStat)
{
    if (hStat && m_hPerfMonServer) {
        ::PERF_Server_Remove_Stat(hStat);
        m_RefCount--;
    }
}

// Stats "heap" implementation
CPerfHeap::CPerfHeap(DWORD* pArea, DWORD size) :
    m_pArea(pArea), m_size(size) 
{
  // lock the "heap" and clean the bitmap
  _LinPageLock(DWORD(m_pArea)>>12, 
         m_size/4096 + ((DWORD(m_pArea)&0x0FFF)?2:1),
          PAGEMAPGLOBAL);
  memset(m_Bitmap, 0, sizeof(m_Bitmap));
}

CPerfHeap::~CPerfHeap()
{ 
  _LinPageUnLock(DWORD(m_pArea)>>12, 
         m_size/4096 + ((DWORD(m_pArea)&0x0FFF)?2:1), PAGEMAPGLOBAL);
}

// Get a DWORD in the area and mark a bit in m_Bitmap as "used":
int CPerfHeap::Allocate()       
{   int i,j;
    for (i=0; i<MAXITEMS; i++) 
        if (m_Bitmap[i] != DWORD(-1)) 
            for (j=0; j<31; j++)
                if ((m_Bitmap[i] & (1<<j))==0)
                    { m_Bitmap[i] |= 1<<j;
                      return i*32+j;
                    }
    return -1;              // too many stats?
}

// Frees the dword at index:
void CPerfHeap::Free(int index) 
{
    if (index>=0 && index<MAXITEMS)
        m_Bitmap[index/32] &= ~(1<<index%32);
}

// end of file
