/////////////////////////////////////////////////////////////
//
// StatDioc.h   -   Definitions for DeviceIoControl API to
//                  of the StatPrxy.VXD
//
// 12/16/96     VV  Original
//
////////////////////////////////////////////////////////////
#ifndef _STATDIOC_H
#define _STATDIOC_H

// DevIoCtrl interface to WHSPERFS.VXD
#define STATDIOC_INIT               1   // set a shared memory
#define STATDIOC_DEINIT             2   // undo init
#define STATDIOC_REGISTER_STAT      4   // register a stat
#define STATDIOC_UNREGISTER_STAT    5   // unregister a stat

#pragma pack(4)
typedef struct {                            // used to register a stat
    const char* pszName; 
    const char* pszDescription;
    const char* pszSubsystem;
    BOOL        bValueNotRate;
} STATDIOC_req_t, *PSTATDIOC_req_t;

typedef struct {                            // driver retutns this:
    int     index;                          // index in the area,>=0
    DWORD   hStatCookie;                    // stats handle
    DWORD   hServerCookie;                  // server handle
} STATDIOC_resp_t, *PSTATDIOC_resp_t;
#pragma pack()

// how we talk to the vxd
#define DRIVER_REQUEST(h, func, struct_p, ret_struct_p, ret_p)  \
    DeviceIoControl(                \
        h,                          \
        func,                       \
        struct_p,                   \
        sizeof(STATDIOC_req_t),     \
        ret_struct_p,               \
        sizeof(STATDIOC_resp_t),    \
        ret_p,                      \
        NULL                        \
 )

#endif // _STATDIOC_H
