/////////////////////////////////////////////////////////////
//
// AppStats.h   -   User's API to SYSMON
//
// 12/16/96     VV  Original
//
////////////////////////////////////////////////////////////
#ifndef _APPSTATS_H
#define _APPSTATS_H

#if !defined(_APPSTATS_IMPLEMENTATION_)
#define APPSTATS_API    __declspec(dllimport)
#else
#define APPSTATS_API    __declspec(dllexport)                     
#endif

typedef DWORD  HSTAT;          // statistics handle 
typedef enum {                  // statistics monitoring mode:
    MONITOR_VALUE,              // by value
    MONITOR_RATE                // by rate of change
} statsmonitor_t;

#define MAX_STATS_NAME  50      // max length of stat item's name

#ifdef  __cplusplus
extern "C" {
#endif

APPSTATS_API HSTAT __stdcall statCreate(const char* szName,
                              statsmonitor_t stType,
                              const char* szDescription,
                              const char* szCategory);
APPSTATS_API BOOL __stdcall statDestroy(const HSTAT hStat);   

APPSTATS_API DWORD __stdcall statGet(const HSTAT hStat);
APPSTATS_API DWORD __stdcall statSet(const HSTAT hStat, 
									 const DWORD dwVal);
APPSTATS_API DWORD __stdcall statInc(const HSTAT hStat,
									 const DWORD dwVal);
APPSTATS_API DWORD __stdcall statDec(const HSTAT hStat, 
									 const DWORD dwVal);

APPSTATS_API BOOL __stdcall statIsInstalled(void);

#ifdef  __cplusplus
 }
#endif  /* __cplusplus */

#endif //_APPSTATS_H
