// Idle.c -- sample Win32 console app using APPSTATS library

#include    <windows.h>
#include    <conio.h>
#include    <stdio.h>
#include    "appstats.h"    // Stats API declarations

DWORD Speed(void)   // wastes time and returns a #/msec
{   DWORD dwTime = GetTickCount();
    DWORD volatile i; 

    for (i=0; i<1000000; i++);
    return i/(GetTickCount()-dwTime+1);
}

void main()
{
    HSTAT hsIdle;           // idle time stats
    HSTAT hsRate;           // running rate stats
    DWORD dwMaxSpeed;

    hsIdle = statCreate("User Idle", MONITOR_VALUE, 
                    "Estimates User Mode Idleness, %", NULL);

    hsRate = statCreate("Speed", MONITOR_RATE,
                    "Estimates how fast we're running", NULL);

    if(!statIsInstalled())
        printf("Unable to install statistics!\n");
    // monopolize the CPU for a while and see what we get
    SetPriorityClass(GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
    dwMaxSpeed = Speed();

    // get idle and monitor what we're  getting
    SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);
    while (!kbhit()) {
        statSet(hsIdle, 100*Speed()/dwMaxSpeed);
        statInc(hsRate, 1);
        printf(".");
    }

    statDestroy(hsIdle);
    statDestroy(hsRate);
}
