// handle.h

template<class T>
class CAuto {  // Smart container for closable objects.
    T m_obj;
public:
    CAuto(T obj = 0) : m_obj(obj) {}
    CAuto(const CAuto& obj)
        : m_obj(const_cast<CAuto<T>&>(obj).reset()) {}
    ~CAuto()
    {
        if ( get() )
            Close(get());
    }
    CAuto& operator=(const T obj)
    {
        T temp = reset(obj);
        if ( temp )
            Close(temp);     // Close previous object.
        return *this;
    }
    CAuto& operator=(const CAuto& obj)
    {
        if ( &obj == this )  // Avoid self assignment.
            return *this;
        return *this = const_cast<CAuto<T>&>(obj).reset();
    }
    T get() const
    {
        return m_obj;
    }
    operator T() const       // Conversion operator.
    {
        return get();
    }
    T reset(const T obj = 0)
    {
        T temp = get();
        m_obj = obj;
        return temp;
    }
};

#endif
// End of File
