#include <assert.h>
#include <stdio.h>
#include "alloc.h"

void    main(void)
    {
    void*   Ptrs[4096];
    int     NPtrs = 0;
    DWORD   Reserved0, Committed0, Reserved, Committed;
    DWORD   InitialRes, InitialCommit;

    Reserved0   = MemStats(&Committed0);
    AllocInit();
    Reserved    = MemStats(&Committed);
    printf("initializing '%s' reserved 0x%08X bytes, committed 0x%08X\n",
        MALLOC_NAME, Reserved-Reserved0, Committed-Committed0);
    
    InitialRes  = Reserved; InitialCommit = Committed;

    assert((Ptrs[NPtrs++]=MALLOC(16*4096)) != 0);
    Reserved    = MemStats(&Committed);
    printf("'%s' (16pages) reserved 0x%08X bytes, committed 0x%08X\n",
        MALLOC_NAME, Reserved-Reserved0, Committed-Committed0);

    Reserved0   = Reserved;
    Committed0  = Committed;
    while(MemStats(0) == Reserved)
        {
        assert((Ptrs[NPtrs++] = MALLOC(0x010000)) != 0);
        assert(NPtrs < sizeof(Ptrs));
        }
    Reserved    = MemStats(&Committed);
    printf("'%s' reserved 0x%08X bytes, committed 0x%08X\n",
        MALLOC_NAME,
        Reserved-Reserved0, Committed-Committed0);
    while(NPtrs > 0)
        FREE(Ptrs[--NPtrs]);
    HEAPMIN();
    
    Reserved    = MemStats(&Committed);
    if(Committed > InitialCommit)
        printf("'%s' failed to decommit 0x%08X\n",
            MALLOC_NAME, Committed-InitialCommit);
    if(Reserved > InitialRes)
        printf("'%s' kept reserved 0x%08x\n", MALLOC_NAME,
            Reserved-InitialRes);
    }
