/* alfloat.cpp - examine effect of misalined doubles */
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#define  ARRAY_SIZE (1024*2)

void Benchmark(double* Array, const char* Name)
    {
    int     i, j;
    DWORD   Start, Stop;
printf("Benchmark starts.\n");
    Start   = GetTickCount();
    for(i = 0; i < 1000; ++i)
        {
        for(j = 0; j < ARRAY_SIZE; ++j)
            Array[j] = i;
        for(j = 0; j < ARRAY_SIZE; ++j)
            Array[j] += 3.5;
        }
    Stop    = GetTickCount();
    printf("Array=0x%08x\n", Array);
    printf("Milliseconds for '%s' = %d\n", Name, Stop - Start);
    }

void main(void)
    {
    int     Gap=1;
    void*   Address;
    double* Array=0;

    Address = malloc((sizeof(double)*ARRAY_SIZE)+4);
    if((long)Address & 0x0007)
        Array   = (double*)Address;
    else
        Array   = (double*)((long)Address + 4);

    /* do it twice to reduce possible caching effects */
    Benchmark(Array, "4-byte aligned");
    Benchmark(Array, "4-byte aligned");

    if(!((long)Address & 0x0007))
        Array   = (double*)Address;
    else
        Array   = (double*)((long)Address+ 4);

    Benchmark(Array, "8-byte aligned");
    Benchmark(Array, "8-byte aligned");
    }
